<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Query;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\CustomerFormMailable;

class QueryController extends Controller
{
    public function saveQuery(Request $request){
        $date_now = Carbon::now();
        $repeat_ip_qty = Query::where('ip_address', $request->ip())
            ->whereDate('created_at', '>=', $date_now->subDays(30))
            ->count();
        $repeat_today = Query::where('ip_address', $request->ip())
            ->whereDate('created_at', '>=', $date_now->subDays(1))
            ->count();

        if($repeat_ip_qty >= 5 || $repeat_today >= 2){
            return false;
        }else{
            $query = new Query();
            $query->fullname = $request->fullname;
            $query->phone = $request->phone;
            $query->email = $request->email;
            $query->message = $request->message;
            $query->query_type_id = 1;
            $query->ip_address = $request->ip();
            $query->save();
        }
    }

    public function saveQueryManual(Request $request){
        
        /* $date_now = Carbon::now();
        $repeat_ip_qty = Query::where('ip_address', $request->ip())
            ->whereDate('created_at', '>=', $date_now->subDays(30))
            ->count();
        $repeat_today = Query::where('ip_address', $request->ip())
            ->whereDate('created_at', '>=', $date_now->subDays(1))
            ->count();

        if($repeat_ip_qty >= 5 || $repeat_today >= 2){
            return false;
        }else{ */
            $query = new Query();
            $query->fullname = $request->name;
            $query->phone = $request->phone;
            $query->email = $request->email;
            $query->query_type_id = 2;
            $query->ip_address = $request->ip();
            $query->save();

            $data = (object) array('username' => $request->fullname);
            $content = new CustomerFormMailable($data);

            Mail::to($request->email)
                ->cc($request->email)
                ->bcc($request->email)
                ->send($content);
        // }
    }
}
