<?php

namespace App\Http\Controllers\api;

use Illuminate\Http\Request;
use App\Models\Place;
use App\Http\Controllers\Controller;

class PlaceController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $places = Place::all();
        return response()->json($places);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $request->validate(['name' => 'required|string|max:160']);
        $place = Place::create(['name' => $request->input('name')]);
        return response()->json(['message' => 'Place created successfully', 'place' => $place], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $place = Place::find($id);
        if (!$place) {
            return response()->json(['message' => 'Place not found'], 404);
        }
        return response()->json($place);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        //
        $request->validate([
            'name' => 'required|string|max:160',
        ]);

        $place = Place::find($id);

        if (!$place) {
            return response()->json(['message' => 'Place not found'], 404);
        }

        $place->update([
            'name' => $request->name,
        ]);

        return response()->json(['message' => 'Place updated successfully', 'place' => $place]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        $place = Place::find($id);

        if (!$place) {
            return response()->json(['message' => 'Place not found'], 404);
        }

        $place->delete();

        return response()->json(['message' => 'Place deleted successfully']);
    }
}
