<?php

namespace App\Http\Controllers\api;

use Illuminate\Http\Request;
use App\Models\Consequence;
use App\Http\Controllers\Controller;

class ConsequenceController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $consequences = Consequence::all();
        return response()->json($consequences);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $request->validate(['description' => 'required|string|max:400']);
        $consequence = Consequence::create(['description' => $request->input('description')]);
        return response()->json(['message' => 'Consequence created successfully', 'consequence' => $consequence], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $consequence = Consequence::find($id);
        if (!$consequence) {
            return response()->json(['message' => 'Consequence not found'], 404);
        }
        return response()->json($consequence);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        //
        $request->validate([
            'description' => 'required|string|max:400',
        ]);

        $consequence = Consequence::find($id);

        if (!$consequence) {
            return response()->json(['message' => 'Consequence not found'], 404);
        }

        $consequence->update([
            'description' => $request->description,
        ]);

        return response()->json(['message' => 'Consequence updated successfully', 'consequence' => $consequence]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        $consequence = Consequence::find($id);

        if (!$consequence) {
            return response()->json(['message' => 'Consequence not found'], 404);
        }

        $consequence->delete();

        return response()->json(['message' => 'Consequence deleted successfully']);
    }
}
