<?php

namespace App\Http\Controllers;

use App\Models\SellerLink;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Helpers\Encryptor;
use App\Models\Country as ModelsCountry;
use App\Models\DocumentType;
use App\Models\Producto;
use Illuminate\Routing\Route;
use App\Helpers\Helper;
use App\Http\Requests\UserSellerRequest;
use App\Models\FractionedPayment;
use App\Models\ProductPayment;
use App\Models\PurchasedProduct;
use Carbon\Carbon;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;

class UsuariosController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth')->except('crearUsuario');
        $this->middleware('admin')->except('crearUsuario', 'invitedUsers', 'crearUsuarioNoVendedor', 'verificarCompras');
        $this->middleware(['seller', 'auth'])->only('invitedUsers');
    }
    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'phone' => ['required', 'string', 'max:9'],
            'permissions[]',
            'rol' => ['required', 'integer'],
        ]);
    }

    public function index(Request $request)
    {
        if($request->seller_id == ""){
            $usuarios = User::leftJoin('course_invitations', 'users.id', '=', 'course_invitations.user_id')
                ->join('document_types', 'users.doc_type_id', '=', 'document_types.id')
                ->leftJoin('productos', 'course_invitations.course_id', '=', 'productos.id')     
                ->where('roles_id', '=', 2)               
                ->select('users.*', 'course_invitations.status', 'document_types.name as doc_type_name', 'productos.nombre as product_name')                
                ->get();
        }else if($request->seller_id == "not_buy"){
            $usuarios = User::leftJoin('course_invitations', 'users.id', '=', 'course_invitations.user_id')
                ->join('document_types', 'users.doc_type_id', '=', 'document_types.id')
                ->leftJoin('productos', 'course_invitations.course_id', '=', 'productos.id')     
                ->where('roles_id', '=', 2)        
                ->where('course_invitations.status','==',0)            
                ->select('users.*', 'course_invitations.status', 'document_types.name as doc_type_name', 'productos.nombre as product_name')                
                ->get();
        }else{
            $usuarios = User::leftJoin('course_invitations', 'users.id', '=', 'course_invitations.user_id')
                ->join('document_types', 'users.doc_type_id', '=', 'document_types.id')
                ->leftJoin('productos', 'course_invitations.course_id', '=', 'productos.id')              
                ->select('users.*', 'course_invitations.status', 'document_types.name as doc_type_name', 'productos.nombre as product_name')                
                ->where('seller_id', $request->seller_id)    
                ->where('roles_id', '=', 2)            
                ->get();
        }
        $this->queryPaymentCompleted($usuarios);
        return $usuarios;
    }

    public function extendDays(Request $request)
    {
        // Obtener la fecha actual con la zona horaria correcta
        $fechaActual = Carbon::now()->setTimezone('America/Lima');
    
        // Calcular la nueva fecha de vencimiento sumando los días solicitados
        $fechaNueva = $fechaActual->copy()->addDays($request->days); // Usar copy() para evitar modificar la fecha actual
    
        // Registra algunos valores clave para depurar
        \Log::info('Fecha actual: ' . $fechaActual);
        \Log::info('Días a agregar: ' . $request->days);
        \Log::info('Nueva fecha calculada: ' . $fechaNueva);
    
        // Actualizar la fecha de vencimiento del producto
        $purchasedProduct = PurchasedProduct::select('purchased_products.created_at', 'purchased_products.id')
            ->join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
            ->where('product_payments.user_id', $request->user_id)
            ->where('purchased_products.product_id', $request->course_id)
            ->first();
    
        $purchased = PurchasedProduct::findOrFail($purchasedProduct->id);
        $purchased->created_at = $fechaNueva; // Actualiza directamente la propiedad created_at
        $purchased->save();
    }
    
    public function queryPaymentCompleted($usuarios){
        foreach ($usuarios as $usuario) {
            if(ProductPayment::where(['user_id' => $usuario->id, 'pay_completed' => 0])->exists()){
                $usuario->pay_completed = 0;
            }else{
                $usuario->pay_completed = 1;
            }
        }
        return $usuarios;
    }

    public function verificarCompras(Request $request){

        $purchaseds = PurchasedProduct::join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
            ->join('productos', 'purchased_products.product_id', '=', 'productos.id')
            ->where('product_payments.user_id', $request->user_id)
            ->select('productos.nombre', 'productos.precio', 'productos.id','productos.months', 'product_payments.status', 
            'product_payments.id as payment_id', 'product_payments.pay_completed', 'product_payments.is_fractioned', 
            'product_payments.amount', 'purchased_products.is_blocked','purchased_products.created_at')
            ->get();
        foreach ($purchaseds as $purchased) {
            if($purchased->is_fractioned == 1){
                $total_paid = FractionedPayment::where('payment_id', $purchased->payment_id)->sum('amount');
                $purchased->total_paid = $total_paid;
            }else{
                $purchased->total_paid = $purchased->amount;
            }
            $purchased->fecha_vencimiento = Carbon::parse($purchased->created_at)->addMonths($purchased->months)->format('d M Y');
        }
        $seller_id = User::where('id', $request->user_id)
            ->pluck('seller_id');
        $pay_auth = $seller_id[0] == auth()->user()->id ? 1 : 0;
        $seller_info = User::where('id', $seller_id[0])
            ->select('id', 'name')
            ->first();
        $delete = $purchaseds->isEmpty();
        $data = [
            'delete' => $delete,
            'purchaseds' => $purchaseds,
            'seller_info' => $seller_info,
            'pay_auth' => $pay_auth
        ];
        return $data;
    }

    public function editar($id)
    {
        $usuario = User::findOrFail($id);

        return view('modules.usuarios', compact('usuario'));
    }

    public function actualizar(Request $request, $id)
    {

        $actualizarUsuario = User::findOrFail($id);

        if ($request->permissions) {
            $permissions = implode(', ', $request->permissions);
        } else {
            $permissions = $request->permissions;
        }

        $actualizarUsuario->name = $request->name;
        $actualizarUsuario->email = $request->email;
        $actualizarUsuario->roles_id = $request->rol;
        $actualizarUsuario->permissions = $permissions;

        $actualizarUsuario->save();
        return back()->with('messageUpdate', 'usuario actualizado');
    }

    public function eliminar(Request $request)
    {
        $eliminarUsuario = User::findOrFail($request->user_id);
        $eliminarUsuario->delete();
    }

    public function listarVendedores()
    {
        $vendedores = User::join('seller_links', 'users.id', '=', 'seller_links.user_id')
            ->select('users.*', 'seller_links.link', 'seller_links.status')
            ->where('roles_id', 3)
            ->get();
        return $vendedores;
    }

    public function listarProfesores()
    {
        /* $profesores= User::get(); */
        $profesores = User::select('users.*')
            ->where('roles_id', 4)
            ->get();
        return view('modules.profesores', compact('profesores'));
    }



    public function crearUsuario($id)
    {
        $id = Encryptor::decrypt($id);
        $prod = Producto::get();
        $country = ModelsCountry::get();
        $documents = DocumentType::all();
        return view('modules.formulario_registro', compact('prod', 'id', 'country', 'documents'));
        //return view('modules.formulario_viejo', compact('prod', 'id', 'country', 'documents'));
    }

    public function crearUsuarioNoVendedor()
    {
        // $country = ModelsCountry::get();
        $documents = DocumentType::all();
        $products = Producto::select('id', 'nombre')->get();
        return view('auth.register', compact('documents', 'products'));
    }
    

    public function crearProfesor()
    {
        $documents = DocumentType::all();
        return view('modules.profesor_crear', compact('documents'));
    }
    public function guardarVendedor(UserSellerRequest $request)
    {
        DB::transaction(function () use ($request) {
            $vendedor = new User();
            $vendedor->name = $request->name;
            $vendedor->email = $request->email;
            $vendedor->password = Hash::make($request->password);
            $vendedor->phone = $request->phone;
            $vendedor->doc_type_id = $request->type_doc;
            $vendedor->number_doc = $request->number_doc;
            $vendedor->country = '';
            $vendedor->birthday = today();
            $vendedor->roles_id = 3;
            $vendedor->save();

            $link = new SellerLink();
            $link->link = env('APP_URL') . '/registrar/' . Encryptor::encrypt($vendedor->id);
            $link->user_id = $vendedor->id;
            $link->save();
        });

        return view('modules.vendedores');
    }

    public function actualizarVendedor(Request $request)
    {
        try {
            DB::beginTransaction();
            $vendedor = User::findOrFail($request->id);
            $vendedor->name = $request->name;
            $vendedor->email = $request->email;

            if($request->password != '' || $request->password != null){
                $vendedor->password = Hash::make($request->password);
            }
            
            $vendedor->phone = $request->phone;
            $vendedor->doc_type_id = $request->doc_type_id;
            $vendedor->number_doc = $request->number_doc;
           
            if ($vendedor->save()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function cambiarEstado(Request $request)
    {
        try {
            DB::beginTransaction();
            $vendedor = SellerLink::where('user_id',$request->id)->get()->first();
            
            if($vendedor->status == 1){
                $vendedor->status = 0;
            }else{
                $vendedor->status = 1;
            }
           
            if ($vendedor->save()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function guardarProfesor(Request $request){
        $id = DB::select("SHOW TABLE STATUS LIKE 'users'");
        $next_id = $id[0]->Auto_increment;
        try {
            DB::beginTransaction();

            $profesor = new User();
            $profesor->name = $request->name;
            $profesor->email = $request->email;
            /* $vendedor->password = bcrypt('nopass'); */
            $profesor->phone=$request->phone;
            $profesor->doc_type_id=$request->doc_type_id;
            $profesor->number_doc=$request->number_doc;
            $profesor->country='';
            $profesor->birthday=$request->birthday;
            $profesor->roles_id = 4;
            $profesor->prefix=$request->prefix;
            $profesor->description=$request->description;
            $profesor->password = substr($profesor->number_doc,'-3').substr($profesor->name,'0','3').substr($profesor->birthday,'0','3');
            
            if ($request->hasFile('file')) {
                $file = $request->file('file');
                $img = Helper::formatFilename($file->getClientOriginalName());
                $path = 'user/' . $next_id . '/' . 'profile'. '/' . 'portada/';   
                Storage::disk('s3')->put($path . $img, file_get_contents($file), 'public');
                $profesor->img = $path . $img;
            } 


            if ($profesor->save()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function actualizarProfesor(Request $request){

        $profesor = User::findOrFail($request->id);

        try {
            DB::beginTransaction();
            $profesor->name = $request->name;
            $profesor->email = $request->email;
            /* $vendedor->password = bcrypt('nopass'); */
            $profesor->phone=$request->phone;
            $profesor->doc_type_id=$request->doc_type_id;
            $profesor->number_doc=$request->number_doc;
            $profesor->country='';
            $profesor->birthday=$request->birthday;
            $profesor->roles_id = 4;
            $profesor->prefix=$request->prefix;
            $profesor->description=$request->description;
            $profesor->password = substr($profesor->number_doc,'-3').substr($profesor->name,'0','3').substr($profesor->birthday,'0','3');
            
            if ($request->hasFile('file')) {
                $newfile = $request->file('file');
                $img = Helper::formatFilename($file->getClientOriginalName());
                $path = 'user/' . $request->id . '/' . 'profile'. '/' . 'portada/';   
               
                if(Storage::disk('s3')->has($profesor->img)){
                    Storage::disk('s3')->delete($profesor->img);
                }
                Storage::disk('s3')->put($path . $img, file_get_contents($newfile), 'public');
                $profesor->img = $path . $img;
            }


            if ($profesor->save()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function borrarProfesor($id)
    {
        $course = User::find($id);
        try {
            DB::beginTransaction();

            Storage::disk('s3')->delete($course->img);

            if ($course->delete()) {
                $response['status'] = 'ok';
            } else {
                $response['status'] = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function crearVendedor(){
        $documents = DocumentType::all();
        return view('modules.vendedor_crear', compact('documents'));
    }

    public function usuarioVendedor($id)
    {
        $usuarios = User::where('seller_id', $id)->get();
        return $usuarios;
    }

    public function info($user_id){
        $user = User::join('document_types', 'users.doc_type_id', '=', 'document_types.id')
            ->select('users.name', 'users.email', 'users.phone', 'document_types.name as doc_name', 'users.number_doc')
            ->where('users.id', $user_id)
            ->first();
        return $user;
    }

    public function viewClassroom($user_id){
        $user = User::findOrFail($user_id);
        $destination = 'purchased_courses';
        $data = [$user->email, $user->password, $destination];
        $data = json_encode($data);
        $data = urlencode($data);
        return $data;
    }

    public function preview(Request $request){
        $user = auth()->user();
        $product = Producto::join('modules', 'productos.id', '=', 'modules.id_courses')
            ->join('class', 'modules.id', '=', 'class.id_modules')
            ->where('productos.slug', $request->slug_product)
            // ->where('class.is_preview', 1)
            ->where(function($query){
                $query->where('class.is_preview', 1)
                    ->orWhere('class.is_preview', 0);
            })
            ->select('class.slug')
            ->first();

        $slug = $product == null ? 'No hay clases' : $product->slug;
        $destination = 'preview';
        $data = [$user->email, $user->password, $destination, $request->slug_product, $slug];
        $data = json_encode($data);
        $data = urlencode($data);
        return $data;
    }

    public function invitedUsers(){
        $user_id = auth()->user()->id;
        if(SellerLink::where('user_id', $user_id)->exists()){
            $data = User::join('course_invitations', 'users.id', '=', 'course_invitations.user_id')
                ->join('productos', 'course_invitations.course_id', '=', 'productos.id')
                ->join('document_types', 'users.doc_type_id', '=', 'document_types.id')
                ->where('users.seller_id', $user_id)
                ->select('productos.nombre as product_name', 'users.*', 'course_invitations.status', 'document_types.name as doc_type_name')
                ->get();
        }else{
            $data = "Usted no tiene autorización para visualizar los datos";
        }
        $this->queryPaymentCompleted($data);
        return $data;
    }
}
