<?php

namespace App\Http\Controllers;

use App\Models\Alert;
use App\Models\News;
use App\Models\Tags;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TagsController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth')->except('');
    }
    // /**
    //  * Idea de mejora
    //  * guardar un rango de fechas en el cual se presentara la alerta, y otro campo el deadline
    //  */
    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            $tag = new Tags();
            $tag->name = $request->name;
            $tag->color = $request->color;
            if ($tag->save()) {
                DB::commit();
                return response()->json(['success' => 'Alerta creada correctamente']);
            } else {
                DB::rollBack();
                return response()->json(['error' => 'Error al crear la alerta']);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    // public function active(Request $request)
    // {
    // }

    public function list()
    {
        $tags = Tags::all();
        return response()->json($tags);
    }
}
