<?php

namespace App\Http\Controllers;

use App\Models\CourseInvitation;
use App\Models\Offer;
use App\Models\ProductPayment;
use App\Models\PurchasedProduct;
use Illuminate\Http\Request;
use App\Models\Producto;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use App\Mail\PurchasedProductMailable;
use App\Mail\PurchasedProductMailableAdmin;
use App\Models\FractionedPayment;
use Illuminate\Support\Facades\DB;

class ProductPaymentController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth')->except('');
    }

    public function listPayments()
    {
        //sub-admin
        $user = auth()->user();
        if($user->roles_id == 6 && $user->id == 267){
            $payments = [];
        }else{
            $payments = ProductPayment::with(['user:id,name', 'product:id,nombre'])->get();
        }
        return $payments;
    }

    public function paymentCourseRequest()
    {
        $payments = ProductPayment::join('users', 'product_payments.user_id', '=', 'users.id')
            ->select('users.name', 'users.id as user_id', 'product_payments.id as payment_id', 'product_payments.created_at as date', 'product_payments.amount', 'product_payments.bank', 'product_payments.reference_code')
            ->where('status', 0)->get();
        return $payments;
    }

    public function approveCoursePayment(Request $request)
    {
        $payment = ProductPayment::findOrFail($request->payment_id);
        $payment->status = 1;
        $payment->update();
        if ($payment->product_type == 3) {
            $products_id = Offer::where('id', $payment->product_id)
                ->pluck('products');
            foreach (json_decode($products_id[0], true) as $product) {
                $purchased = new PurchasedProduct();
                $purchased->payment_id = $payment->id;
                $purchased->product_id = $product;
                $purchased->save();
                self::courseInvitations($product, $payment->user_id);
            }
        } else {
            $purchased = new PurchasedProduct();
            $purchased->payment_id = $payment->id;
            $purchased->product_id = $payment->product_id;
            $purchased->save();
            self::courseInvitations($payment->product_id, $payment->user_id);
        }

        $user = User::find($payment->user_id);

        $product = Producto::where('id',  $purchased->product_id)
            ->select('nombre', 'precio', 'portada_url')
            ->first();

        $path = $path = "https://ipssoma-storage.s3.eu-west-1.amazonaws.com/" . $product->portada_url;

        $data = (object) array(
            'product_name' => $product->nombre,
            'price' => $product->precio,
            'portada' => $path,
            'email' => $user->email,
            // 'email' => $user->email,
            'username' => $user->name,
            'date' => Carbon::now(),
        );

        $content = new PurchasedProductMailable($data);

        Mail::to($user->email)
            ->send($content);
    }

    static public function courseInvitations($course_id, $user_id)
    {
        if (CourseInvitation::where('user_id', $user_id)->exists()) {
            $invitation = CourseInvitation::where('user_id', $user_id)->first();
            if ($invitation->course_id == $course_id) {
                $invitation->status = 1;
                $invitation->update();
            }
        }
    }

    public function rejectCoursePayment(Request $request)
    {
        $payment = ProductPayment::findOrFail($request->payment_id);
        $payment->status = 2;
        $payment->justification = $request->justification;
        $payment->update();
    }

    public function makePayment(Request $request)
    {
        DB::transaction(function () use ($request) {
            $fractioned = new FractionedPayment();
            $fractioned->payment_id = $request->payment_id;
            $fractioned->amount = $request->amount;
            $fractioned->reference_code = "pago interno";
            $fractioned->bank = "pago interno";
            $fractioned->status = 1;
            $fractioned->save();

            $payment = ProductPayment::findOrFail($request->payment_id);
            if ($payment->product_type == 3) {
                $product_price = Offer::where('id', $payment->product_id)->pluck('price');
            } else {
                $product_price = Producto::where('id', $payment->product_id)->pluck('precio');
            }
            $actual_total_amount = $payment->amount + $fractioned->amount;
            $payment->amount = $actual_total_amount;
            $payment->pay_completed = $actual_total_amount >= $product_price[0] ? 1 : 0;
            $payment->update();
        });
    }
}
