<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Models\Offer;
use App\Models\Producto;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class OfferController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth')->except('offerList', 'productsInfo');
    }

    public function saveOffer(Request $request){
        $id = DB::select("SHOW TABLE STATUS LIKE 'offers'");
        $next_id = $id[0]->Auto_increment;
        $offer = new Offer();
        $offer->name = $request->name;
        $offer->price = $request->price;
        $offer->slug = Str::slug($request->name);
        $offer->products = $request->products;

        $offer->status = 0; //estado de publicacion 0:no publicar | 1:publicar
        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $portada = Helper::formatFilename($file->getClientOriginalName());
            $path = 'ofertas/' . $next_id . '/' . 'portada/';
            Storage::disk('s3')->put($path . $portada, file_get_contents($file), 'public');
            $offer->portada_name = $portada;
            $offer->portada_url = $path . $portada;
        }
        $offer->save();
    }

    public function updateOffer(Request $request){
        $offer = Offer::where('id', $request->id)->first();
        $offer->name = $request->name;
        $offer->price = $request->price;
        $offer->slug = Str::slug($request->name);
        $offer->products = $request->products;
        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $portada = Helper::formatFilename($file->getClientOriginalName());
            if(Storage::disk('s3')->has($offer->portada_url)){
                Storage::disk('s3')->delete($offer->portada_url);
            }
            $path = 'ofertas/' . $offer->id . '/' . 'portada/';
            Storage::disk('s3')->put($path . $portada, file_get_contents($file), 'public');
            $offer->portada_name = $portada;
            $offer->portada_url = $path . $portada;
        }
        $offer->update();
    }

    public function offerList(){
        $offers = Offer::all();
        foreach ($offers as $offer) {
            $names = [];
            $products = json_decode($offer->products, TRUE);
            // $offer->products = json_decode($products, TRUE);
            $offer->products = $products;
            foreach ($products as $product) {
                $nombre = Producto::where('id', $product)->pluck('nombre');
                array_push($names, $nombre[0]);
            }
            $offer->product_names = $names;
        }
        return $offers;
    }

    public function productsInfo(Request $request){
        $data = [];
        $offers = json_decode($request->offer, true);
        $product_ids = $offers['products'];
        foreach ($product_ids as $offer) {
            $product = Producto::where('id', $offer)
                ->select('id', 'nombre', 'precio')
                ->get();
            array_push($data, $product[0]);
        }
        return $data;
    }

    public function changeStatus($id){
        $offer = Offer::findOrFail($id);
        if($offer->status == 0){
            $offer->status = 1;
            $message = "La oferta es visible para los usuarios";
        }else if($offer->status == 1){
            $offer->status = 0;
            $message = "Se ha ocultado la oferta";
        }
        $offer->update();
        return $message;
    }
}
