<?php

namespace App\Http\Controllers;

use App\Models\Clas;
use App\Models\Video;
use App\Models\Module;
use App\Helpers\Helper;
use App\Models\Producto;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\ClassResource;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;

class ModuleClassController extends Controller
{
    protected $user;
    // crear constructor para asignar id del usuario
    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $this->user = Auth::user();
            return $next($request);
        });
    }


    public function index(Module $module)
    {
        $lessons = $module->lessons;
        return $lessons;
    }

    // Estados de un curso
    // public function changeStatus(Request $request)
    // {
    //     /**
    //      * 0 -> no revisado - default
    //      * 1 -> desaprobado
    //      * 2 -> aprobado
    //      */
    //     $class_id = $request->id;
    //     $class = Clas::where('id', $class_id)->get()->first();
    //     $actual_module = Module::where('id', $class->id_modules)->first();

    //     // disapproved
    //     if ($request->status == 1) {
    //         try {
    //             DB::beginTransaction();
    //             $class->status = 1;
    //             if ($class->update()) {
    //                 // Create observation
    //                 $productor_id = $this->getProductor($class_id);
    //                 $course_id = $this->getCourse($class_id);
    //                 $analyst_id = Auth::user()->id;

    //                 $pending_revission = Clas::where('id_modules', $actual_module->id)
    //                     ->whereIn('status', [0, 4])
    //                     ->first();
    //                 //check for pending revisions in the actual module
    //                 if($pending_revission == null){
    //                     $actual_module->status = 1;
    //                     $actual_module->update();
    //                 }
    //                 // creamos las observaciones sin enviarlas al usuario
    //                 CourseObservationController::storeObservation($class_id, $analyst_id, $productor_id, $request->observation, $course_id);
    //             }
    //             DB::commit();
    //         } catch (\Throwable $th) {
    //             DB::rollBack();
    //             throw $th;
    //         }
    //     } else {
    //         // approved or change status of the pending observations 
    //         $course_obs = CourseObservation::where('id_class', $class_id)->get()->first();
    //         if($course_obs){
    //             $course_obs->status = 2;
    //             $course_obs->update();
    //         }

    //         $class->status = 2;
    //         $class->update();

    //         $pending_revission = Clas::where('id_modules', $actual_module->id)
    //             ->whereIn('status', [0, 4])
    //             ->first();
    //         //check for pending revisions in the actual module
    //         if($pending_revission == null){
    //             $dissaproved_class = Clas::where('id_modules', $actual_module->id)
    //                 ->where('status', 1)->first();
    //             if($dissaproved_class == null){
    //                 $actual_module->status = 2;
    //                 $actual_module->update();
    //             }else{
    //                 $actual_module->status = 1;
    //                 $actual_module->update();
    //             }
    //         }
    //     }
    // }

    public function getProductor($class_id)
    {
        //search_module_by_class
        $module_id = Clas::where('id', $class_id)->where('status', 1)->get()->first()->id_modules;
        // search_course_by_module
        $course_id = Module::where('id', $module_id)->get()->first()->id_courses;
        //search_user_by_course
        $user_id =  Producto::where('id', $course_id)->get()->first()->user_id;
        return $user_id;
    }

    public function getCourse($class_id)
    {
        $module_id = Clas::where('id', $class_id)->where('status', 1)->get()->first()->id_modules;
        $course_id = Module::where('id', $module_id)->get()->first()->id_courses;
        return $course_id;
    }


    /**
     * Method to save a class
     */
    public function save(Request $request)
    {
        $user = Auth::user();
        $actual_module = Module::where('id', $request->module_id)->get()->first();
        $module_name = $actual_module->name;
        $actual_course = Producto::where('id', $actual_module->id_courses)->get()->first();
        $course_name = Helper::formatToFolderName($actual_course->title);
        $course_id = $actual_course->id;
        $empty_module = false;
        $empty_modules = false;
        $last_order_in_class = Clas::where('id_modules', $request->module_id)->where('status', 1)
            ->select('order')
            ->orderBy('order', 'desc')
            ->first();
        if($last_order_in_class == null){
            $empty_module = true;

            $modules_above = Module::where('id', '<', $request->module_id)
                ->where('id_courses', $course_id)
                ->orderBy('id', 'desc')
                ->pluck('id');
            $count = 0;
            if(sizeof($modules_above) == 0){
                $count = 1;
                $empty_modules = true;
                $empty_module = false;
                $last_order_in_class = (object) array('order' => $count);
            }else{
                foreach ($modules_above as $module_id) {
                    $count++;
                    if(Clas::where('id_modules', $module_id)->exists()){
                        $last_order_in_class = Clas::where('id_modules', $module_id) 
                            ->select('order') 
                            ->orderBy('order', 'desc')
                            ->first();
                        break;
                    }
                }
                if($last_order_in_class == null){
                    $empty_modules = true;
                    $empty_module = false;
                    $count++;
                    $last_order_in_class = (object) array('order' => $count);
                }
            }
        }
        $all_classes = Clas::join('modules', 'class.id_modules', '=', 'modules.id')->where('class.status', 1)
            ->where('class.order', '>', $last_order_in_class->order)
            ->where('modules.id_courses', $course_id)
            ->pluck('class.id');

        foreach ($all_classes as $class_id) {
            $class = Clas::findOrFail($class_id);
            $class->order += 1;
            $class->update();
        }

        try {
            DB::beginTransaction();
            $class = new Clas();
            $class->id_modules = $request->module_id;
            $class->name = $request->title;
            $class->slug = Str::slug($request->title);
            $class->description = $request->description;
            $class->is_preview = $request->is_preview;
            $class->time = $request->time;
            if($empty_module){
                $class->order = $last_order_in_class->order + $count + 1;
            }else if($empty_modules){
                $class->order = $count + 1;
            }else{
                $class->order = $last_order_in_class->order + 1; //
            }
            $class->public_status = 0;
            $class->external_links = $request->external_links;
            $class->url = '/class/example';

            if ($class->save()) {
                if ($request->is_preview == 1) {
                    $this->changeAllLessonStatus($class->id, $course_id);
                }

                $class_name = Helper::formatToFolderName($request->title);
                // Save video of class
                if($request->isReusable == 1){
                    VideoController::storeReusableVideo($request->video_id, $class->id);
                    $resources = json_decode($request->resources, true);
                    if($resources != null){
                        ClassResourceController::storeReusableResources($resources, $class->id);
                    }
                }else{
                    if ($request->file('video')) {
                        $video = $request->file('video');
                        VideoController::storeClassVideo($video, $user->id, $course_id, $class->id);
                    }
    
                    // Save resources of class
                    $resources = $request->resources;
    
                    if ($resources !== null) {
                        if (count($resources) > 0) {
                            $storeResources = ClassResourceController::storeClassResources($resources, $user->id, $course_id, $class->id);
                        }
                    }
                }
                $response['status'] = 'ok';
                $response['classes'] = Clas::where('id_modules', $request->module_id)->get();

                if ($actual_course->status == 2) {
                    $actual_course->status = 4;
                    $actual_course->update();
                }
                $actual_module->public_status = 0;
                $actual_module->update();
            } else {
                $response['status']  = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param  \App\Models\Module  $module
     * @return \Illuminate\Http\Response
     */
    public function create(Module $module)
    {
        return view('content.courses.modules.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Module  $module
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, Module $module)
    {
        $lesson = new Clas;
        $lesson->name = $request->name;
        $lesson->id_modules = $module->id;
        $lesson->time = '00:00:00';
        $lesson->url = '/class/example';
        $lesson->description = 'description';
        $lesson->save();
        return $lesson;
    }

    public static function delete($id)
    {
        //sub admin
        $rol_id = auth()->user()->roles_id;
       
        if($rol_id == 6){
            return false;
        }else{
            try {
                DB::beginTransaction();
                $class = Clas::where('id', $id)->where('status', 1)->first();
               
                $course = Clas::join('modules', 'class.id_modules', '=', 'modules.id')
                    ->where('class.id', $id)
                    ->select('modules.id_courses')
                    ->first();
                    
                // $classes = Clas::join('modules', 'class.id_modules', '=', 'modules.id')
                //     ->where('modules.id_courses', $course->id_courses)
                //     ->where('class.order', '>', $class->order)
                //     ->pluck('class.id');

                   
                // foreach ($classes as $class_id) {
                //     $class_item = Clas::findOrFail($class_id);
                //     $class_item->order -= 1;
                //     $class_item->update();
                // }
                $classes_resource = ClassResource::where('class_id', $class->id)->get();
                
                $class_video = Video::where('class_id', $class->id)->get();
                
                ClassResourceController::deleteClassResource($classes_resource);
                
                VideoController::deleteClassVideo($class_video);

                $class->status = 0;
    
                if ($class->update()) {
                    $response['status'] = 'ok';
                } else {
                    $response['status'] = 'error';
                }
                echo json_encode($response);
                DB::commit();
            } catch (\Throwable $th) {
                Log::error('error al eliminar', ['message' => $th->getMessage()]);
                DB::rollBack();
                throw $th;
            }
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Module  $module
     * @param  \App\Models\Clas  $cla
     * @return \Illuminate\Http\Response
     */
    public function show(Module $module, Clas $cla)
    {
        $this->verifyModule($module, $cla);
        return $cla;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Module  $module
     * @param  \App\Models\Clas  $cla
     * @return \Illuminate\Http\Response
     */
    public function edit(Module $module, Clas $cla)
    {
        $this->verifyModule($module, $cla);
        return view('content.courses.modules.lessons.edit', compact('module', 'cla'));
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Module  $module
     * @param  \App\Models\Clas  $cla
     * @return \Illuminate\Http\Response
     */
    public function destroy(Module $module, Clas $cla)
    {
        $this->verifyModule($module, $cla);
        $cla->delete();
        return $cla;
    }

    // public function addVideo(Request $request, Module $module, Clas $cla)
    // {
    //     $this->verifyModule($module, $cla);
    //     $request->validate([
    //         'path' => 'required|mimes:mp4,ogx,oga,ogv,ogg,webm',
    //     ]);
    //     $path = $request->file('path')->store('courses/modules/class');
    //     // $image = $request->file('image')->store('courses');

    //     $video = Video::make(
    //         ['path' => $path]
    //     );

    //     $cla->video()->save($video);
    //     return redirect()->back()->withSuccess('The video has been uploaded successfully.');
    // }

    // public function delVideo(Module $module, Clas $cla)
    // {
    //     $this->verifyModule($module, $cla);
    //     Storage::delete($cla->video->path);
    //     $cla->video()->delete();
    //     return redirect()->back()->withSuccess('The video has been deleted.');
    // }

    // protected function verifyModule(Module $module, Clas $cla)
    // {
    //     if ($module->id != $cla->id_modules) {
    //         throw new HttpException(422, 'The specified module is not the actual module of the class');
    //     }
    // }

    public function getDetailsClass(Request $request)
    {
        $class_data = Clas::where('name', 'like', $request->name)->where('status', 1)
            ->get();
        // $class_data = Clas::findOrFail($request->id);
        return $class_data;
    }


    public function getClassList($id)
    {
        $classes = Clas::where('id_modules', $id)->where('status', 1)
            ->orderBy('order', 'asc')
            ->get();
        echo json_encode($classes);
    }

    public function listObservations($course_id)
    {
        $course_observations_list =  CourseObservation::where([
            'id_course' => $course_id,
            'status' => 1
        ])->get();

        echo json_encode($course_observations_list);
    }



    public function getClassDetails($id)
    {
        // $resources = ClassResource::where('class_id', $id)->get();
        $video = Video::where('class_id', $id)->get();
        return json_encode(compact('video'));
    }

    public function update($id, Request $request)
    {
        //sub admin
        $rol_id = auth()->user()->roles_id;
        // if($rol_id == 6){
        //     return false;
        // }else{
            $module_id = Clas::where('id', $id)->where('status', 1)->get()->first()->id_modules;
            $actual_module = Module::where('id', $module_id)->get()->first();
            $actual_course = Producto::where('id', $actual_module->id_courses)->get()->first();
            $course_name = Helper::formatToFolderName($actual_course->title);
            $course_id = $actual_course->id;
            try {
                DB::beginTransaction();
                $class = Clas::where('id', $id)->get()->first();
                $class->name = $request->title;
                $class->slug = Str::slug($request->title);
                $class->description = $request->description;
                $class->is_preview = $request->is_preview;
                $class->external_links = $request->external_links;
                // Al actualizar la clase se debe revisar
                // Si el curso esta publicado no mostrará la clase pendiente a revisión
                // $class->public_status = '0'; //cambiado a status 4 para nueva revision
    
                if ($class->update()) {
                    // if ($request->is_preview == 1) {
                    //     $this->changeAllLessonStatus($class->id, $course_id);
                    // }
                    if ($request->hasFile('video')) {
                        $video = $request->file('video');
                        VideoController::updateClassVideo($video, $course_id, $id);
                    }
    
                    $resources = $request->resources;
                    $resourcesRemoved = $request->resourcesRemoved;
    
                    if ($resourcesRemoved !== null) {
                        if (count($resourcesRemoved) > 0) {
                            $destroyResources = ClassResourceController::destroyClassResource($resourcesRemoved, $id);
                        }
                    }
    
                    if ($resources !== null) {
                        if (count($resources) > 0) {
                            $updateResources = ClassResourceController::updateClassResource($resources, $this->user->id, $course_id, $id);
                        }
                    }
    
                    // $actual_module->public_status = 0;
                    // $actual_module->update();
                    $response['status'] = 'ok';
                    echo json_encode($response);
                }
                DB::commit();
            } catch (\Throwable $th) {
                DB::rollBack();
                throw $th;
            }
        // }
    }

    /**
     * Cambia el estado de todas las clases a 0
     */
    public function changeAllLessonStatus($excludeId, $courseId)
    {
        $modulesId = Module::where('id_courses', $courseId)->get()->pluck('id')->toArray();
        foreach ($modulesId as $moduleId) {
            $classes = Clas::where('id_modules', $moduleId)->where('status', 1)->get();
            foreach ($classes as $class) {
                if ($class->id != $excludeId) {
                    $class->is_preview = 0;
                    $class->update();
                }
            }
        }
    }
}
