<?php

namespace App\Http\Controllers;

use App\Models\Clas;
use App\Models\Module;
use App\Models\Producto;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpKernel\Exception\HttpException;

class CourseModuleController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth')->except('');
    }
    
    public function index(Producto $course)
    {
        $modules = $course->modules;
        return $modules;
    }

    public function create(Producto $course)
    {
        $this->authorize('update', $course);
        return view('content.courses.modules.create', compact('course'));
    }

    public function store(Request $request)
    {
        // $this->authorize('update', $course);
        // $module = $course->modules()->create($request->validated());
        // return $module;
        try {
            DB::beginTransaction();
            $module = new Module();
            $module->id_courses = $request->course_id;
            $module->name = $request->name;
            $module->public_status = 0;
            if ($module->save()) {
                $response['status'] = 'ok';
                $response['modules'] = Module::where('id_courses', $request->course_id)->get();
            } else {
                $response['status']  = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function show(Producto $course, Module $module)
    {
        $this->verifyCourse($course, $module);
        return $module;
    }

    public function update($id, Request $request)
    {
        $module = Module::where('id', $id);
        $module->update([
            'name' => $request->name
        ]);
        echo json_encode($request->name);
    }

    public static function delete($id)
    {
        //sub admin
        $rol_id = auth()->user()->roles_id;
        if($rol_id == 6){
            return false;
        }else{
            $course_id = Module::where('id', $id)->first()->id_courses;
            try {
                DB::beginTransaction();
                $module = Module::where('id', $id)->first();
                $classes = Clas::where('id_modules', $module->id)->where('status', 1)->get();
    
                if (count($classes)) {
                    foreach ($classes as $class) {
                        ModuleClassController::delete($class->id);
                    }
                }
                self::removeOnePositionToClasses($course_id, $module->id);
                if ($module->delete()) {
                    $res['modules'] =  Module::where('id_courses', $course_id)->get();
                    $res['status'] = 'ok';
                } else {
                    $res = 'error';
                }
                echo json_encode($res);
                DB::commit();
            } catch (\Throwable $th) {
                DB::rollBack();
                throw $th;
            }
        }
    }

    static public function removeOnePositionToClasses($id_course, $id_module){
        $classes_id = Clas::join('modules', 'class.id_modules', '=', 'modules.id')->where('class.status', 1)
            ->where('modules.id_courses', $id_course)
            ->where('modules.id', '>', $id_module)
            ->pluck('class.id');
        foreach ($classes_id as $class_id) {
            $class = Clas::findOrFail($class_id);
            $class->order -= 1;
            $class->update();
        }
    }

    protected function verifyCourse(Producto $course, Module $module)
    {
        if ($course->id != $module->id_courses) {
            throw new HttpException(422, 'The specified course is not the actual course of the modules');
        }
    }

    public function createModule(Request $request)
    {
        //necesario id del productor y del curso
        // $modules = Module::join('courses', 'modules.id_courses', '=', 'courses.id')
        //     ->join('users', 'courses.user_id', '=', 'users.id')
        //     ->where('courses.id', '=', $request->id_course)
        //     ->where('users.id', '=', auth()->user()->id)
        //     ->select('modules.*', 'modules.*')
        //     ->get();

        // return view('content.courses.modules.create', compact('modules'));
        return view('content.courses.modules.create');
    }

    //implementacion para mostrar las clases de los modulos en el front
    // public function showModulesClass(Request $request)
    // {
    //     $modulesClass = Course::join('modules', 'courses.id', '=', 'modules.id_courses')
    //         ->join('class', 'modules.id', '=', 'id_modules')
    //         ->where('courses.id', '=', $request->id_courses)
    //         ->where('')
    //         ->get();
    //     return response()->toJson($modulesClass);
    // }







    // Show the view to manage the modules of specific course
    public function editModule($id)
    {
        //sub admin
        $rol_id = auth()->user()->roles_id;
        if($rol_id == 6 && $id != 33){
            $id = 7;
            $course = Producto::where('id', $id)->get()->first();
            $modules = Module::where('id_courses', $id)->get();
        }else{
            $course = Producto::where('id', $id)->get()->first();
            $modules = Module::where('id_courses', $id)->get();
        }
        return view('content.courses.modules.edit', compact('course', 'modules'));
    }

    public function moduleList($id){
        $modules = Module::where('id_courses', $id)->get();
        return $modules;
    }
}
