@extends('adminlte::page')

@section('title', 'Ipssoma / Dashboard')

@section('content_header')
    {{-- google ads --}}
    <script async src="https://www.googletagmanager.com/gtag/js?id=AW-11111928634"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());
    gtag('config', 'AW-11111928634');
    </script>
    {{-- google analytics --}}
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-C4PSP030TR"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-C4PSP030TR');
    </script>
@stop

@section('content')
<div class="container">
    <div class="card p-3">
        <div class="row">
            <div class="col-sm-6 col-lg-3">
                <h4>Lista de Productos </h4>
            </div>
            <div class="col-sm-6 col-lg-9">
                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#ModalProductCreate">Agregar nuevo producto</button>
            </div>
        </div>
    </div>
    @if(session('info'))
    <div class="alert alert-success">
        <strong>{{session('info')}}</strong>
    </div>
    @endif
    <div class="card p-3">
        <div class="cad-body">
            <table class="table w-100 table-responsive-sm table-striped">
                <thead>
                    <th>ID</th>
                    <th>Producto</th>
                    <th>Precio</th>
                    <th>URL</th>
                    <th colspan="2">Operaciones</th>
                </thead>
                <tbody>
                    @foreach($prod as $product)
                        <tr>
                            <td>{{$product->id}}</td>
                            <td>{{$product->nombre}}</td>
                            <td>{{$product->precio}}</td>
                            <td>{{$product->url_portada}}</td>
                            <td><a class="btn btn-success"href="{{Route('product.edit',$product->id)}}">Editar</a></td>
                            <td><a class="btn btn-danger" href="{{Route('product.delete',$product->id)}}">Eliminar</a></td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="card-footer">
                {{$prod->withQueryString()->links('pagination::bootstrap-4')}}
        </div>
    </div>
</div>
<div class="modal fade" id="ModalProductCreate" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Agregar Producto</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
            <form action="{{Route('product.create')}}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="form-row">
                    <div class="form-group col-6">
                        <label>Producto</label>
                        <input type="text" class="form-control" name="nombre" placeholder="Ingrese nombre del producto">
                    </div>
                    <div class="form-group col-6">
                        <label>Precio S/.</label>
                        <input type="text" class="form-control" name="precio" placeholder="Ingrese precio del producto">
                    </div>
                </div>
                <div class="form-group">
                    <label>Portada</label>
                    <input type="file" name="portada" class="form-control">
                </div>
                <div class="form-group">
                    <label>Descripción</label>
                    <textarea class="ckeditor form-control" name="descripcion"></textarea>
                </div>
                <div class="form-group">
                    <label>Objetivo</label>
                    <textarea class="ckeditor form-control" name="objetivo"></textarea>
                </div>
                <div class="form-group text-center">
                    <button type="submit" class="btn btn-primary w-100">Agregar nuevo producto</button>
                </div>
            </form>
        </div>
      </div>
    </div>
</div>
@if($status)
    <div class="modal fade" id="ModalProductEdit" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
            <h5 class="modal-title">Editar Producto</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            </div>
            <div class="modal-body">
                <form action="{{Route('product.store',['id'=>$data->id])}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-row">
                        <div class="form-group col-6">
                            <label>Producto</label>
                            <input type="text" class="form-control" name="nombre" value="{{$data->nombre}}" placeholder="Ingrese nombre del producto">
                        </div>
                        <div class="form-group col-6">
                            <label>Precio S/.</label>
                            <input type="text" class="form-control" name="precio" value="{{$data->precio}}" placeholder="Ingrese precio del producto">
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Portada</label>
                        <input type="file" name="portada" class="form-control" value="{{$data->portada_name}}">
                    </div>
                    <div class="form-group">
                        <label>Descripción</label>
                        <textarea class="ckeditor form-control" name="descripcion">{{$data->descripcion}}</textarea>
                    </div>
                    <div class="form-group">
                        <label>Objetivo</label>
                        <textarea class="ckeditor form-control" name="objetivo">{{$data->objetivo}}</textarea>
                    </div>
                    <div class="form-group text-center">
                        <button type="submit" class="btn btn-primary w-100">Editar producto</button>
                    </div>
                </form>
            </div>
        </div>
        </div>
    </div>
@endif
@endsection

@section('js')
<script src="//cdn.ckeditor.com/4.17.1/basic/ckeditor.js"></script>
<script>
    $(document).ready(function() {
        $('#ModalProductEdit').modal('toggle');
        $('.ckeditor').ckeditor();
    });
</script>
@endsection