<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ProcessSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Array de procesos
        $processes = [
            'Proceso de producción',
            'Proceso de ensamblaje',
            'Proceso de empaquetado',
            'Proceso de control de calidad',
            // Agrega más procesos según sea necesario
        ];

        // Iterar sobre cada proceso y crear un registro en la tabla 'processes'
        foreach ($processes as $process) {
            DB::table('processes')->insert([
                'name' => $process,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
