<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PlaceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $places = [
            'Oficina principal',
            'Sede de producción',
            'Almacén',
            'Tienda',
            // Añade más lugares según sea necesario
        ];

        // Iterar sobre cada descripción y crear un registro en la tabla 'dangers'
        foreach ($places as $place) {
            DB::table('places')->insert([
                'name' => $place,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
