<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class IsoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('isos')->insert([
            'name' => 'ISO 9001:2005',
            'intro' => 'Implementar la norma ISO 9001:2015 en su empresa tendrá múltiples beneficios. No solo ahorrará tiempo, dinero y ganará en eficiencia ya que se mejorarán sus procesos de manera destacada. También evitará sanciones por incumplimiento de alguna normativa y su imagen empresarial mejorará de cara a clientes, proveedores y terceras partes. Por ello le recomendamos actualizar a esta versión ISO 9001:2015.',
            'time_obtaining' => 'El tiempo promedio de obtener el certificado ISO 9001:2015, es de seis meses, aunque depende de numerosos factores, como su disposición y organización para crear el Sistema de Gestión de Calidad o su tamaño. En empresas pequeñas de hasta 50 trabajadores la norma puede estar implantada en unos cuatro meses. En cambio, las empresas medianas necesitan unos ocho meses, mientras que las grandes pueden requerir hasta 15 meses.', 
            'time_validity' => 'Una vez otorgada, la certificación tiene una validez de tres años, trascurrido este periodo es necesaria una auditoría de renovación y la emisión de un nuevo certificado. Anualmente la entidad de certificación debe realizar auditorías de seguimiento para asegurar el cumplimiento de los requisitos de la norma.',
            'benefits' => 'La implementación de un sistema de gestión de calidad impulsará la mejora continua de la empresa, sirviendo de base para la certificación de otros estándares:

                Permite establecer claramente tus objetivos, alineándolos a la estrategia de la organización para identificar nuevas oportunidades de negocio.
                Asegura el cumplimiento de las necesidades de los clientes para superar sus expectativas.
                Mantiene metodologías implementadas para identificar y tratar los riesgos asociados con tu organización.
                Ahorro de recursos e incremento de la satisfacción del personal, al tener procesos más eficaces y ordenados.',

            'url_image_cover' => 'static/1covercard-iso-9001.webp',
            'cover_name' => 'card-iso-9001.webp',
            'url_image_page' => 'static/1pageportada-iso9001.webp',
            'page_name' => 'portada-iso9001.webp',
        ]);

        DB::table('isos')->insert([
            'name' => 'ISO 14001',
            'intro' => 'La gestión de una empresa en general, deberá conocer el tiempo que se tardará en implementar la norma ISO 14001 versión 2015 desde el principio hasta el final. Del mismo modo, deberán tener en cuenta los recursos que serán necesarios para un proyecto de aplicación que deberán ser evaluados, y quién es el mejor en su empresa para administrar el proyecto. Por lo tanto, será preciso que el director de proyecto tenga conocimientos sobre la propia norma ISO 14001 versión 2015, sino también en el contexto en el que opera la empresa y el efecto que tendrá sobre el tiempo de implantación.',
            'time_obtaining' => 'Por regla general, la mayoría de las empresas tienen que estar listas en unos seis meses, si hablamos de organizaciones que tengan 20 o menos trabajadores, pero las organizaciones de mayor tamaño pueden tardar más tiempo, incluso un año.', 
            'time_validity' => 'La certificación ISO 14001 tiene una vigencia de 3 años desde la fecha de la emisión del certificado, sujeto a auditorías de seguimiento anuales.',
            'steps_implementation' => 'Si tu empresa quiere implementar la norma ISO 14001 y certificar su Sistema de Gestión Ambiental, puede resultar abrumador averiguar por donde comenzar. Para ayudarle, durante este artículo queremos hacer un resumen sobre cómo implementar la norma ISO 14001 y como prepararse para obtener la certificación.

            Conseguir el apoyo por la dirección
            El apoyo de la dirección es fundamental. Sin este apoyo la implementación de la norma ISO 14001 seguramente fracasará. Por este motivo, es necesario tener un buen argumento para convencer a la dirección que implementa la norma ISO 14001.
            
            Identificar requisitos legales
            Es necesario que se asegure de que se han identificado los requisitos legales y otros requisitos relativos al Sistema de Gestión Ambiental, ya que esto es otro paso necesario para asegurarse de que su implantación tiene éxito.
            
            Definir el alcance del Sistema de Gestión Ambiental
            Para asegurarse de que conoce los límites de lo que se debe hacer, es necesario que se defina el alcance de su Sistema de Gestión Ambiental. Esto ayuda a evitar la inclusión de áreas de su negocio que no tengan un efecto sobre el medio ambiente. Las herramientas para definir el alance son la política ambiental y los aspectos ambientales, siendo estos los primeros documentos que se necesitan para crear el Sistema de Gestión Ambiental.
            
            Definir los procesos y procedimientos del Sistema de Gestión Ambiental
            Se trata de incluir los procesos y los procedimientos que se identifican como necesarios para asegurarse de que los resultados serán coherentes y adecuados a la hora de prevenir impactos ambientales negativos y responder antes situaciones de emergencia.
            
            Implantar los procesos y procedimientos del Sistema de Gestión Ambiental
            Los procesos se encuentran vinculados a los procesos que ya existen en su empresa, como el seguimiento de los residuos de sus instalaciones. Ya que no todos los procesos necesitan ser procedimientos documentados, es importante destacar cuales se documentarán, para de esta forma evitar daños al medio ambiente.
            
            Realizar formación y sensibilización
            Los empleados deben tener formación sobre conceptos básicos, como qué es la norma ISO 14001 y por qué la empresa ha implantado esto, y además, tienen que recibir la formación sobre los procesos que hayan cambiado. Es muy importante que todos en la empresa sepan lo que se encuentran haciendo con respecto al Sistema de Gestión Ambiental y cómo encajan en la ecuación.
            
            Seleccionar una entidad certificadora
            La entidad certificadora es la organización que se dedica a auditar los procesos del Sistema de Gestión Ambiental, los cuales tienen que cumplir con los requisitos de la norma ISO 14001. También comprobarán si el sistema es eficiente y se mejora de forma continua. Es mucho mejor analizar diferentes entidades de certificación para decidirse por cual es la más adecuada para su organización, ya que esto puede ser un paso muy importante en la implementación eficiente del sistema.',

            'url_image_cover' => 'static/2covercard-iso14001.webp',
            'cover_name' => 'card-iso14001.webp',
            'url_image_page' => 'static/2pageportada-iso14001.webp',
            'page_name' => 'portada-iso14001.webp',
        ]);

        DB::table('isos')->insert([
            'name' => 'ISO 37001',
            'intro' => 'ISO 37001 es la nueva norma internacional que especifica los requisitos y proporciona las mejores prácticas para establecer, implementar y mantener un Sistema de Gestión Anti soborno (SGAS) en la organización y es aplicable en cualquier país.',
            'time_obtaining' => 'El tiempo de implementación de los requisitos de ISO 37001 se determina en base a criterios puntuales como: Tipo de organización, personal, puestos, sedes y el alcance que pretende certificar. Nos referimos al alcance a determinar si en todos los procesos de la organización o solo un proceso en particular se implementará ISO 37001; ambas opciones con válidas para desarrollar un proceso de certificación ante un organismo de certificación, puesto que la norma nos permite implementar por proceso. En ese sentido, los tiempos de implementación para las organizaciones que no tienen ningún ISO implementado son de 6 meses para empresas pequeñas, de 8 a 10 meses para empresas medianas y grandes empresa no debería ser mayor a 12 meses.', 
            'time_validity' => 'El certificado tiene una validez de 3 años, con auditorías anuales de mantenimiento.',
            
            'url_image_cover' => 'static/4covercard-iso45001.webp',
            'cover_name' => 'card-iso45001.webp',
            'url_image_page' => 'static/4pageportada-iso45001.webp',
            'page_name' => 'portada-iso45001.webp',
            
        ]);

        DB::table('isos')->insert([
            'name' => 'ISO 45001: 2018',
            'intro' => 'Tiene como objetivo gestionar la seguridad y la salud en el trabajo para ayudar a las organizaciones que opten por este sistema de gestión en su labor de prevenir los riesgos laborales, así como mejorar su imagen de cara a la sociedad demostrando su compromiso con la seguridad.',
            'time_obtaining' => 'En una empresa de 20 personas, una implantación de 45001 puede ser posible en unos seis meses. Depende del enfoque, el conocimiento, la experiencia y los recursos disponibles. Para las grandes empresas, un año puede ser necesario. Esto puede depender de diferentes factores.', 
            'time_validity' => 'El certificado tiene una validez de 3 años, con auditorías anuales de mantenimiento.',
            'steps_implementation' => 'Solicitud de certificación: El cliente deberá ponerse en contacto con la empresa y dar los datos necesarios.

            Propuesta de certificación: Evaluaremos la Solicitud de Certificación y enviaremos la Propuesta de Certificación al cliente junto con el Contrato de servicio que deberán firmar ambas partes.
            
            Auditorias de certificación: Se programa la Auditoría de Certificación en dos etapas:
            
            Fase 1: revisión de los documentos y verificar la preparación para la auditoría final.
            
            Fase 2: visita de campo para verificación de la implementación de la norma.
            
            Emisión del Certificado: El Comité Técnico se reúne para evaluar el resultado de la Auditoría de Certificación. Una vez obtenido el resultado favorable, se emite el certificado correspondiente con una vigencia de tres (03) años.
            
            Auditorías de Seguimiento I y II: Se realizará auditoría de seguimiento para verificar que el cliente ha mantenido los controles implementados. Luego de la auditoría se reúne el Comité Técnico para evaluar la decisión de certificación y si procede, se emite un nuevo certificado con las nuevas fechas de seguimiento.
            
            Auditoría de Recertificación: Se lleva a cabo para renovar la vigencia de la certificación y validar el cumplimiento de los requisitos de la Norma ISO certificada.',

            'url_image_cover' => 'static/3covercard-iso37001.webp',
            'cover_name' => 'card-iso37001.webp',
            'url_image_page' => 'static/3pageportada-iso37001.webp',
            'page_name' => 'portada-iso37001.webp',
        ]);
    }
}
