<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DangerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        $descriptions = [
            'Peligro eléctrico',
            'Peligro químico',
            'Peligro de caída',
            'Peligro de incendio',
            // Añade más descripciones según sea necesario
        ];

        // Iterar sobre cada descripción y crear un registro en la tabla 'dangers'
        foreach ($descriptions as $description) {
            DB::table('dangers')->insert([
                'description' => $description,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

    }
}
