<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ConsequenceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $consequences = [
            'Lesión por caída desde altura',
            'Intoxicación por inhalación de gases tóxicos',
            'Quemaduras por contacto con sustancias químicas',
            'Amputación de extremidades por atrapamiento en maquinaria',
            'Estrés térmico por exposición a altas temperaturas',
            'Dermatitis por contacto con irritantes cutáneos',
            // Añade más consecuencias según sea necesario
        ];

        // Iterar sobre cada descripción y crear un registro en la tabla 'consequences'
        foreach ($consequences as $consequence) {
            DB::table('consequences')->insert([
                'description' => $consequence,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
