<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOperationalControlTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('operational_control', function (Blueprint $table) {
            $table->id();
            $table->foreignId('iperc_id')->constrained('iperc')->onUpdate('cascade')->onDelete('cascade');
            $table->text('elimination');
            $table->text('sustitution');
            $table->text('engineering_control');
            $table->text('admin_control');
            $table->text('epps');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('operational_control');
    }
}
