<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRiskEvaluationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('risk_evaluation', function (Blueprint $table) {
            $table->id();
            $table->foreignId('risks_id')->constrained('risks')->onUpdate('cascade')->onDelete('cascade');
            $table->enum('type',['inherent','residual']);
            $table->integer('index_a');
            $table->integer('index_b');
            $table->integer('index_c');
            $table->integer('index_d');
            $table->integer('probability');
            $table->integer('severity');
            $table->integer('ps');
            $table->char('NV',2);
            $table->tinyInteger('signification');
            $table->string('actions',200)->nullable()->default('');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('risk_evaluation');
    }
}
