<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMessageTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('message', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('conversation_id')->nullable();
            $table->string('api_id')->nullable()->unique();
            $table->json('choices')->nullable();
            $table->json('usage');
            $table->datetime('date_of_issue')->nullable();
            $table->string('status')->nullable();
            $table->enum('emisor', ['User', 'Gpt']);
            $table->timestamps();

            $table->foreign('conversation_id')->references('id')->on('conversation');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('message');
    }
}
