<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserExamHeadersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_exam_headers', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger('rate');
            $table->boolean('status');
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('productor_id')->nullable();
            $table->unsignedBigInteger('exam_id');
            $table->text('condition');
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users');
            $table->foreign('productor_id')->references('id')->on('users');
            $table->foreign('exam_id')->references('id')->on('exams');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_exam_headers');
    }
}
