<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPuntosYTiempoToExamsTable extends Migration
{
    public function up()
    {
        Schema::table('exams', function (Blueprint $table) {
            if (!Schema::hasColumn('exams', 'isDelete')) {
                $table->tinyInteger('isDelete')->default(0);
            }
            if (!Schema::hasColumn('exams', 'time')) {
                $table->bigInteger('time')->nullable()->after('title');
            }
            if (!Schema::hasColumn('exams', 'max_score')) {
                $table->integer('max_score')->default(20);
            }
            if (!Schema::hasColumn('exams', 'min_passing_score')) {
                $table->double('min_passing_score')->default(11);
            }
            if (!Schema::hasColumn('exams', 'course_id')) $table->bigInteger('course_id')->unsigned()->nullable();
            if (!Schema::hasColumn('exams', 'module_id')) $table->bigInteger('module_id')->unsigned()->nullable();
            if (!Schema::hasColumn('exams', 'lesson_id')) $table->bigInteger('lesson_id')->unsigned()->nullable();
        });

        Schema::table('user_exam_headers', function (Blueprint $table) {
            if (!Schema::hasColumn('user_exam_headers', 'user_exam_id')) {
                $table->bigInteger('user_exam_id')->unsigned()->nullable()->after('exam_id');
            }
        });
    }

    public function down()
    {
        Schema::table('exams', function (Blueprint $table) {
            $table->dropColumn(['isDelete', 'time', 'max_score', 'min_passing_score', 'course_id', 'module_id', 'lesson_id']);
        });

        Schema::table('user_exam_headers', function (Blueprint $table) {
            $table->dropColumn(['user_exam_id']);
        });
    }
}