<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddUserExamIdToUserExamHeaders extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('user_exam_headers', function (Blueprint $table) {
             
              $table->foreignId('user_exam_id') 
              ->nullable()
              ->constrained('user_exams') 
              ->onDelete('cascade'); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_exam_headers', function (Blueprint $table) {
            $table->dropConstrainedForeignId('user_exam_id');
        });
    }
}
