<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterForeignKeyOnUserQuestionAnswers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('user_question_answers', function (Blueprint $table) {
            // Drop the existing foreign key constraint
            
            //$table->dropForeign(['user_exam_id']);  

          
            $table->foreign('user_exam_id')
                  ->references('id') 
                  ->on('user_exam_headers')
                  ->onDelete('cascade') 
                  ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_question_answers', function (Blueprint $table) {
            
            $table->dropForeign(['user_exam_id']);  

          
            $table->foreign('user_exam_id')
                  ->references('id') 
                  ->on('user_exams')
                  ->onDelete('cascade') 
                  ->onUpdate('cascade');
        });
    }
}
