<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnClassStatusTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('class', 'status')) {
            Schema::table('class', function (Blueprint $table) {
                $table->tinyInteger('status')->default(1);
            });
        }

        if (!Schema::hasColumn('class_resources', 'status')) {
            Schema::table('class_resources', function (Blueprint $table) {
                $table->tinyInteger('status')->default(1);
            });
        }

        if (!Schema::hasColumn('videos', 'status')) {
            Schema::table('videos', function (Blueprint $table) {
                $table->tinyInteger('status')->default(1);
            });
        }

        if (!Schema::hasColumn('exams', 'isDelete')) {
            Schema::table('exams', function (Blueprint $table) {
                $table->tinyInteger('isDelete')->default(1);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('class', 'status')) {
            Schema::table('class', function (Blueprint $table) {
                $table->dropColumn('status');
            });
        }

        if (Schema::hasColumn('class_resources', 'status')) {
            Schema::table('class_resources', function (Blueprint $table) {
                $table->dropColumn('status');
            });
        }

        if (Schema::hasColumn('videos', 'status')) {
            Schema::table('videos', function (Blueprint $table) {
                $table->dropColumn('status');
            });
        }

        if (Schema::hasColumn('exams', 'isDelete')) {
            Schema::table('exams', function (Blueprint $table) {
                $table->dropColumn('isDelete');
            });
        }
    }
}
