<?php

namespace Database\Factories;

use App\Models\DocumentType;
use Illuminate\Database\Eloquent\Factories\Factory;

class SSTClientFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $document_types = DocumentType::all()->pluck('id');

        return [
            'name' => $this->faker->name(),
            'lastname' => $this->faker->name(),
            'doc_type_id' => $document_types->random(),
            'num_doc' => $this->faker->numberBetween(10000000, 99999999),
            'name_certificate' => $this->faker->name(),
            'cod_certificate' => $this->faker->numberBetween(100, 1000),
            'filename' => "empty",
        ];
    }
}
