<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SSTClient extends Model
{
    use HasFactory;
    protected $table = "sst_clients";
    protected $fillable = [
        'id',
        'name',
        'lastname',
        'doc_type_id',
        'num_doc',
        'name_certificate',
        'code_certificate',
        'filename',
    ];

    public function documentType(){
        return $this->belongsTo(DocumentType::class, 'doc_type_id');
    }
}
