<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RiskEvaluation extends Model
{
    use HasFactory;
    protected $table = 'risk_evaluation';
    protected $fillable = [
        'risks_id',
        'type',
        'index_a',
        'index_b',
        'index_c',
        'index_d',
        'probability',
        'severity',
        'ps',
        'NV',
        'signification',
    ];

    public function risk()
    {
        return $this->belongsTo(Risk::class, 'risks_id');
    }
}
