<?php

namespace App\Models;

use Database\Factories\ProductoFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Producto extends Model
{
    use HasFactory;
    protected $table = "productos";
    protected $fillable = [
        'id',
        'nombre',
        'descripcion',
        'objetivo',
        'will_learn',
        'prev_knowledge',
        'course_for',
        'precio',
        "ranking_by_user",
        'portada_name',
        'portada_url',
        'video_name',
        'video_url',
    ];

    protected static function newFactory()
    {
        return ProductoFactory::new();
    }

    // public function getImageAttribute($value)
    // {
    //     return asset('storage/images/' . $value);
    // }

    public function getPortadaUrlAttribute($value)
    {
        if (!$value) {
            return null;
        }
        if (strpos($value, 'http') === 0) {
            return $value;
        }
        return env('AWS_S3_URL') . '/' . $value;
    }

    public function getVideoUrlAttribute($value)
    {
        if (!$value) {
            return null;
        }
        if (strpos($value, 'http') === 0) {
            return $value;
        }
        return env('AWS_S3_URL') . '/' . $value;
    }

    public function modules(): HasMany
    {
        return $this->hasMany(Module::class, 'id_courses');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(Module::class, 'id');
    }

    public function productPayments()
    {
        return $this->hasMany(ProductPayment::class, 'product_id');
    }

    protected $casts = [
        'created_at' => 'datetime:d-m-Y',
    ];
}
