<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OperationalControl extends Model
{
    use HasFactory;

    protected $table = 'operational_control';

    protected $fillable = [
        'iperc_id',
        'elimination',
        'sustitution',
        'engineering_control',
        'admin_control',
        'epps',
    ];

    // Relación con la tabla 'iperc'
    public function iperc()
    {
        return $this->belongsTo(IPERC::class,'iperc_id');
    }
}
