<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class News extends Model
{
    use HasFactory;

    public function tags()
    {
        return $this->belongsToMany(Tags::class, 'news_tags_detail', 'new_id', 'tag_id');
    }
    public function author()
    {
        return $this->belongsTo(User::class, 'author_id');
    }

    protected $casts = [
        'created_at' => 'datetime:d-m-Y',
    ];

    public function getThumbnailAttribute($value)
    {
        return env('AWS_S3_URL') . '/' . $value;
    }
}
