<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Module extends Model
{
    use HasFactory;
    protected $table = 'modules';

    public function lessons(): HasMany
    {
        return $this->hasMany(Clas::class, 'id_modules');
    }

    public function course(): BelongsTo
    {
        return $this->belongsTo(Course::class, 'id_courses');
    }   
}