<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IPERC extends Model
{
    use HasFactory;

    protected $table = 'iperc';

    protected $fillable = [
        'matrix_id',
        'places_id',
        'processes_id',
        'tasks_id',
        'work_positions_id',
        'risks_id',
        'dangers_id',
        'consequences_id',
        'type',
        'routine',
    ];

    // Relación con la tabla 'places'
    public function place()
    {
        return $this->belongsTo(Place::class, 'places_id');
    }

    // Relación con la tabla 'processes'
    public function process()
    {
        return $this->belongsTo(Process::class, 'processes_id');
    }

    // Relación con la tabla 'tasks'
    public function task()
    {
        return $this->belongsTo(Task::class, 'tasks_id');
    }

    // Relación con la tabla 'work_positions'
    public function workPosition()
    {
        return $this->belongsTo(WorkPosition::class, 'work_positions_id');
    }

    // Relación con la tabla 'risks'
    public function risk()
    {
        return $this->belongsTo(Risk::class, 'risks_id');
    }

    // Relación con la tabla 'dangers'
    public function danger()
    {
        return $this->belongsTo(Danger::class, 'dangers_id');
    }

    public function matrix()
    {
        return $this->belongsTo(Matrix::class, 'matrix_id');
    }

    public function consequence()
    {
        return $this->belongsTo(Consequence::class, 'consequences_id');
    }
    public function operationalControls()
    {
        return $this->hasMany(OperationalControl::class, 'iperc_id');
    }
}
