<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Conversation extends Model
{
    use HasFactory;
    protected $table = 'conversation';

    protected $fillable = [
        'user_id',
        'start_date',
        'last_activity',
        'status',
        'is_active',
        'status_bot'
    ];


    public function messages()
    {
        return $this->hasMany(Message::class);
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }
}
