<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RegisterMailableAlone extends Mailable
{
    use Queueable, SerializesModels;

    public $subject = 'Tu registro fue realizado con éxito.';
    public $data;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from(env('MAIL_USERNAME'), 'IPSSOMA org')
                ->subject('Tu compra fue procesada con éxito')
                ->view('emails.user_registered_alone');
    }
}
