<?php

namespace App\Http\Requests;

use Carbon\Carbon;
use Illuminate\Foundation\Http\FormRequest;

class UserRequest2 extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            // 'name' => ['required','unique:users','min:3','max:50'],
            'name' => ['required','min:2','max:50'],
            'email' => ['required','unique:users'],
            'password' => ['required','min:5','confirmed'],
            'phone' => ['required','min:1000000','integer','unique:users'],
            'doc_type_id' => ['required','exists:document_types,id'],
            'number_doc' => ['required','min:00000000','unique:users'],
            'country' => ['required','exists:countries,id'],
            'birthday' => ['required','date','before:' . Carbon::now()->subYears(18)],
        ];
    }

    public function messages(){
        return [
            'name.required' => 'Ingrese su nombre',
            'name.min' => 'Ingrese su nombre correctamente',
            'name.max' => 'Se sobrepasó la longitud máxima',
            'email.required' => 'Ingrese su correo electrónico',
            'email.email' => 'Su correo electrónico debe tener el formato correcto',
            'email.unique' => 'El correo electrónico ya fue registrado anteriormente',
            'password.required' => 'Ingrese una contraseña',
            'password.min' => 'La contraseña debe contener al menos 5 letras',
            'password.confirmed' => 'Las contraseñas no coincide',
            'phone.required' => 'Ingrese su teléfono',
            'phone.min' => 'El Teléfono debe contener 9 dígitos',
            'phone.integer' => 'El teléfono debe ser numérico',
            'doc_type_id.required' => 'Seleccione un tipo de documento',
            'doc_type_id.exists' => 'Seleccione un tipo de documento',
            'number_doc.required' => 'Ingrese su número de documento',
            'number_doc.integer' => 'El Número de documento solo debe contener números',
            'number_doc.min' => 'El Número de documento debe contener al menos 8 caracteres',
            'number_doc.unique' => 'El Número de documento ya ha sido registrado',
            'country.required' => 'Seleccione su país de origen',
            'country.exists' => 'El país seleccionado no es válido',
            'birthday.required' => 'Ingrese su fecha de nacimiento',
            'birthday.date' => 'Ingrese su fecha de nacimiento',
            'birthday.before' => 'Debe ser mayor de edad para poder registrarse',
        ];
    }
}
