<?php

namespace App\Http\Controllers\api;

use Illuminate\Http\Request;
use App\Models\WorkPosition;
use App\Http\Controllers\Controller;

class WorkPositionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $workPositions = WorkPosition::all();
        return response()->json($workPositions);

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $request->validate(['name' => 'required|string|max:160']);
        $workPosition = WorkPosition::create(['name' => $request->input('name')]);
        return response()->json(['message' => 'Work Position created successfully', 'workPosition' => $workPosition], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $workPosition = WorkPosition::find($id);
        if (!$workPosition) {
            return response()->json(['message' => 'Work position not found'], 404);
        }
        return response()->json($workPosition);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        //
        $request->validate([
            'name' => 'required|string|max:160',
        ]);

        $workPosition = WorkPosition::find($id);

        if (!$workPosition) {
            return response()->json(['message' => 'Work Position not found'], 404);
        }

        $workPosition->update([
            'name' => $request->name,
        ]);

        return response()->json(['message' => 'Work Position updated successfully', 'workPosition' => $workPosition]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        $workPosition = WorkPosition::find($id);

        if (!$workPosition) {
            return response()->json(['message' => 'WorkPosition not found'], 404);
        }

        $workPosition->delete();

        return response()->json(['message' => 'WorkPosition deleted successfully']);
    }
}
