<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\PurchasedProduct;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log; 

class PurchasedProductController extends Controller
{
    public function saveTimeClass(Request $request)
    {
        try {
            if (!$request->course_id || !$request->class_id) {
                return response()->json(['error' => 'Faltan datos (course_id o class_id)'], 400);
            }

            
            if ($request->display_time == 0) {
                return response()->json(['status' => 'no_update', 'message' => 'Time was 0'], 200);
            }

            $purchasedItem = PurchasedProduct::join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
                ->where('product_payments.user_id', auth()->user()->id)
                ->where('purchased_products.product_id', $request->course_id)
                ->select('purchased_products.*') 
                ->first();

            if (!$purchasedItem) {
                return response()->json(['error' => 'Producto comprado no encontrado'], 404);
            }

            
            $info = $purchasedItem->classes_info ?? [];
            
            $info[$request->class_id] = [
                'time' => $request->display_time,
            ];

            $purchasedItem->classes_info = $info;
            $purchasedItem->save(); 
            
            return response()->json(['status' => 'success', 'data' => $purchasedItem], 200);

        } catch (\Exception $e) {
            Log::error("Error en saveTimeClass: " . $e->getMessage());
            return response()->json(['error' => 'Server Error: ' . $e->getMessage()], 500);
        }
    }


    public function getTime(Request $request)
    {
        try {
            \Log::info("--- TRACE BACKEND: getTime solicitado ---", [
                'user' => auth()->user()->id,
                'course' => $request->courseId,
                'class' => $request->classId
            ]);

            $purchased = PurchasedProduct::join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
                ->where('product_payments.user_id', auth()->user()->id)
                ->where('purchased_products.product_id', $request->courseId)
                ->select('purchased_products.classes_info')
                ->first();

            if (!$purchased) {
                \Log::warning("--- TRACE BACKEND: No se encontró producto comprado ---");
                return response()->json(['time' => 0]);
            }

            $info = $purchased->classes_info;
            $time = 0;

            if (is_array($info) && isset($info[$request->classId])) {
                $time = $info[$request->classId]['time'] ?? 0;
            }

            \Log::info("--- TRACE BACKEND: Tiempo recuperado ---", ['time' => $time]);

            return response()->json(['time' => $time]);

        } catch (\Exception $e) {
            Log::error("Error en trace getTime: " . $e->getMessage());
            return response()->json(['time' => 0, 'error' => $e->getMessage()]);
        }
    }
}