<?php

namespace App\Http\Controllers\api;

use Illuminate\Http\Request;
use App\Models\Danger;
use App\Http\Controllers\Controller;

class DangerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $dangers = Danger::all();
        return response()->json($dangers);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $request->validate(['description' => 'required|string|max:400']);
        $danger = Danger::create(['description' => $request->input('description')]);
        return response()->json(['message' => 'Danger created successfully', 'danger' => $danger], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $danger = Danger::find($id);
        if (!$danger) {
            return response()->json(['message' => 'Danger not found'], 404);
        }
        return response()->json($danger);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        //
        $request->validate([
            'description' => 'required|string|max:400',
        ]);

        $danger = Danger::find($id);

        if (!$danger) {
            return response()->json(['message' => 'Danger not found'], 404);
        }

        $danger->update([
            'description' => $request->description,
        ]);

        return response()->json(['message' => 'Danger updated successfully', 'danger' => $danger]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        $danger = Danger::find($id);

        if (!$danger) {
            return response()->json(['message' => 'Danger not found'], 404);
        }

        $danger->delete();

        return response()->json(['message' => 'Danger deleted successfully']);
    }
}
