<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Models\SSTClient;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;

class SSTClientController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth')->except('');
    }
    
    public function listarClientesSST(){
        $clientes = SSTClient::with('documentType:id,name')->get();
        return $clientes;
    }

    public function guardarClienteSST(Request $request){
        try {
            DB::beginTransaction();
            $client = new SSTClient();
            $client->name = $request->name;
            $client->lastname = $request->lastname;
            $client->doc_type_id = $request->doc_type_id;
            $client->num_doc = $request->num_doc;
            $client->name_certificate = $request->name_certificate;
            $client->cod_certificate = $request->cod_certificate;
            if ($request->hasFile('img_certificate')){
                $file = $request->file('img_certificate');
                $filename = Helper::formatFilename($file->getClientOriginalName());
                $path = "certificados/";
                Storage::disk('s3')->put($path . $filename, file_get_contents($file), 'public');
                $client->filename = $filename;
            }
            if ( $client->save()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
            $client = new SSTClient();
            $client->name = $request->name;
            $client->lastname = $request->lastname;
            $client->doc_type_id = $request->doc_type_id;
            $client->num_doc = $request->num_doc;
            $client->name_certificate = $request->name_certificate;
            $client->cod_certificate = $request->cod_certificate;
            if ($request->hasFile('img_certificate')){
                $file = $request->file('img_certificate');
                $filename = Helper::formatFilename($file->getClientOriginalName());
                $path = "certificados/";
                Storage::disk('s3')->put($path . $filename, file_get_contents($file), 'public');
                $client->filename = $filename;
            }
            $client->save();
        }
    }

    public function actualizarClienteSST(Request $request){
        $client = SSTClient::findOrFail($request->id);


        try {
            DB::beginTransaction();
            $client->name = $request->name;
            $client->lastname = $request->lastname;
            $client->doc_type_id = $request->doc_type_id;
            $client->num_doc = $request->num_doc;
            $client->name_certificate = $request->name_certificate;
            $client->cod_certificate = $request->cod_certificate;
            if ($request->hasFile('img_certificate')){
                $path = "certificados/";
                Storage::disk('s3')->delete($path.$client->filename);
                $file = $request->file('img_certificate');
                $filename = Helper::formatFilename($file->getClientOriginalName());
                Storage::disk('s3')->put($path . $filename, file_get_contents($file), 'public');
                $client->filename = $filename;
            }
            if ($client->update()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }

        
    }

    public function delete($id)
    {
        $course =SSTClient::find($id);
        try {
            DB::beginTransaction();

            Storage::disk('public')->delete($course->filename);

            if ($course->delete()) {
                $response['status'] = 'ok';
            } else {
                $response['status'] = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;

        }
    }
}
