<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\PurchasedProduct;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log; 

class PurchasedProductController extends Controller
{
    public function saveTimeClass(Request $request)
    {
        try {
            if (!$request->course_id || !$request->class_id) {
                return response()->json(['error' => 'Faltan datos (course_id o class_id)'], 400);
            }

            if ($request->display_time != 0) {
                $purchasedItem = PurchasedProduct::join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
                    ->where('product_payments.user_id', auth()->user()->id)
                    ->where('purchased_products.product_id', $request->course_id)
                    ->select('purchased_products.*') 
                    ->first();

                if (!$purchasedItem) {
                    return response()->json(['error' => 'Producto comprado no encontrado para este usuario'], 404);
                }

                if ($purchasedItem->classes_info == null) {
                    $aux = array(
                        $request->class_id => [
                            'time' => $request->display_time,
                        ]
                    );
                    $purchasedItem->classes_info = $aux; 
                    $purchasedItem->update();
                } else {
                    $object = is_string($purchasedItem->classes_info) 
                        ? json_decode($purchasedItem->classes_info, true) 
                        : $purchasedItem->classes_info;

                    $object[$request->class_id] = array(
                        'time' => $request->display_time,
                    );
                    $purchasedItem->classes_info = $object;
                    $purchasedItem->update();
                }
                
                return response()->json(['status' => 'success', 'data' => $purchasedItem], 200);
            }
            
            return response()->json(['status' => 'no_update', 'message' => 'Time was 0'], 200);

        } catch (\Exception $e) {
            Log::error("Error en saveTimeClass: " . $e->getMessage());
            return response()->json(['error' => 'Server Error: ' . $e->getMessage()], 500);
        }
    }

    public function getTime(Request $request)
    {
        try {
            $purchased_info = PurchasedProduct::join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
                ->where('product_payments.user_id', auth()->user()->id)
                ->where('purchased_products.product_id', $request->courseId)
                ->value('purchased_products.classes_info'); // 'value' es más eficiente que 'pluck' para un solo campo

            if (!$purchased_info) {
                return 0;
            }

            $class_time = is_string($purchased_info) ? json_decode($purchased_info, true) : $purchased_info;

            if (isset($class_time[$request->classId])) {
                return $class_time[$request->classId];
            }

            return 0; 

        } catch (\Exception $e) {
            Log::error("Error en getTime: " . $e->getMessage());
            return 0;
        }
    }
}