<?php

namespace App\Http\Controllers;

use App\Models\Clas;
use App\Models\ClassResource;
use App\Models\CourseCategory;
use App\Models\Module;
use Illuminate\Http\Request;
use App\Models\Producto;
use App\Models\PurchasedProduct;
use App\Models\TipoProducto;
use Illuminate\Support\Facades\DB;

class ProductosController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth')->except('index', 'tipoProducto', 'courseCategories');
    }

    public function index(){
        //sub admin
        $user = auth()->user();
        if($user->roles_id == 6 && $user->id == 18){
            $productos = [];
        }else{
            $productos = Producto::whereNotIn('estado_publicacion', [3])->get();
        }
        return $productos;
    }

    public function allCoursesList(){
        $productos = Producto::select('id', 'nombre')->get();
        return $productos;
    }

    public function allClassesWithVideoList($id){
        $classes = Module::join('class', 'modules.id', '=', 'class.id_modules')
            ->join('videos', 'class.id', '=', 'videos.class_id')
            ->where('modules.id_courses', $id)
            ->where('class.status', 1)
            ->select('class.id', 'class.name')
            ->get();
        return $classes;
    }

    public function classInfo($id){
        $class = Clas::leftJoin('videos', 'class.id', '=', 'videos.class_id')
            ->select('class.*', 'videos.path', 'videos.id as video_id')
            ->where('class.id', $id)
            ->where('class.status', 1)
            ->first();
        $class->url = env("AWS_S3_URL").'/'.$class->path;
        $resources = ClassResource::where('class_id', $id)
            ->select('id', 'filename')
            ->get();
        $data = [
            'class' => $class,
            'resources' => $resources
        ];
        return $data;
    }

    public function create(Request $request){
        DB::beginTransaction();

        if($request->file()){
            $portada_name = $request->file('portada')->getClientOriginalName();
            $portada_url = $request->file('portada')->store('public/portada_producto');
            $portada_url = str_replace("public","storage",$portada_url);
        }

        $prod = new Producto();
        $prod->nombre = $request->nombre;
        $prod->descripcion = $request->descripcion;
        $prod->objetivo = $request->objetivo;
        $prod->precio = $request->precio;
        $prod->portada_name = @$portada_name;
        $prod->portada_url = @$portada_url;
        $prod->save();

        DB::commit();

        return redirect('productos/list')->with('info','El producto fue registrado exitosamente');
    }
    public function edit($id){
        $data = Producto::find($id);
        $prod = Producto::paginate();
        $status = true;
        return view("modules.productos",compact("data","prod","status"));
    }
    public function store(Request $request){
        DB::beginTransaction();
        
        if($request->file()){
            $portada_name = $request->file('file')->getClientOriginalName();
            $portada_url = $request->file('file')->store('public/portada_producto');
            $portada_url = str_replace("public","storage",$portada_url);
        }


        $prod = Producto::find($request->id);
        $prod->nombre = $request->nombre;
        $prod->slug = $request->nombre;
        $prod->descripcion = $request->descripcion;
        $prod->objetivo = $request->objetivo;
        $prod->precio = $request->precio;
        $prod->estado_publicacion = $request->estado_publicacion;
        $prod->portada_name = @$portada_name;
        $prod->portada_url = @$portada_url;
        $prod->save();

        DB::commit();
        return redirect('productos/list')->with('info','Los cambios del producto fueron registrados');
    }
    public function delete($id){
        //sub admin
        $rol_id = auth()->user()->roles_id;
        if($rol_id == 6){
            $message = "No cuenta con los permisos necesarios para realizar esta acción";
        }else{
            $prod = Producto::find($id);
            $prod->delete();
            $message = 'El producto fue removido exitosamente';
        }
        return redirect("productos/list")->with('info', $message);
    }

    public function tipoProducto(){
        $prod = TipoProducto::where('producto', 'not like', 'Oferta')
            ->get();
        return $prod;
    }

    public function courseCategories(){
        $prod = CourseCategory::get();
        return $prod;
    }

    public function editModule($id)
    {
        $course = Producto::where('id', $id)->get()->first();
        // $modules = Module::where('id_courses', $id)->get();
        $modules = [];
        return view('content.courses.modules.edit', compact('course','modules'));
    }

    public function getOrders($id){
        $data = collect();
        $modules = Producto::join('modules', 'productos.id', '=', 'modules.id_courses')
            ->where('productos.id', $id)
            ->select('modules.id', 'modules.name')
            ->get();
        foreach ($modules as $module) {
            $module->type = "module";
            $data->push($module);
            $class = Clas::where('id_modules', $module->id)->where('status', 1)
                ->select('id', 'name')
                ->orderBy('order', 'asc')
                ->get();
            if(!$class->isEmpty()){
                foreach ($class as $item) {
                    $item->type = "class";
                    $data->push($item);
                }
            }
        }
        return $data;
    }

    public function changeOrder(Request $request){
        $items = json_decode($request->order, true);
        $module_id = 0;
        $i = 1;
        $item_id = 0;
        foreach ($items as $item) {
            $type = $item['type'];
            if($type == "module"){
                $item_id = $item['id'];
                $module_id = $item_id;
            }else{
                $item_id = $item['id'];
                $class = Clas::where('status', 1)->findOrFail($item_id);
                $class->id_modules = $module_id;
                $class->order = $i;
                $class->update();
            }
            $i++;
        }
        return $items;
    }

    public function blockAccess(Request $request){
        $payment = PurchasedProduct::where('payment_id', $request->payment_id)
            ->where('product_id', $request->product_id)
            ->first();
        $payment->is_blocked = $payment->is_blocked == 0 ? 1 : 0;
        $payment->update();
        return $payment->is_blocked;
    }
}
