<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Models\ClassResource;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ClassResourceController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth')->except('');
    }
    
    public function showResources(Request $request)
    {
        $resources = ClassResource::join('class', 'class_resources.class_id', '=', 'class.id')
            ->where('class.name', '=', $request->name)
            ->select('class_resources.*')
            ->get();
        return $resources;
    }

    public static function storeClassResources($resources, $user_id, $course_id, $class_id)
    {
        foreach ($resources as $index => $items) {
            $name = Helper::formatFilename($resources[$index]->getClientOriginalName());
            if(!ClassResource::where(['filename' => $name, 'class_id' => $class_id])->exists()){
                $path = 'courses/' . $user_id . '/' . $course_id  . '/' . $class_id  . '/' . 'resources/';
                $class_resource = new ClassResource();
                $class_resource->class_id = $class_id;
                $class_resource->resource_file = $path . $name;
                $class_resource->filename = $name;
                $class_resource->save();
                Storage::disk('s3')->put($path . $name, file_get_contents($resources[$index]), 'public');
            }
        }
    }

    public static function storeReusableResources($resources, $class_id){
        foreach ($resources as $resource) {
            $resource_template = ClassResource::findOrFail($resource["id"]);
            $new_resource = new ClassResource();
            $new_resource->class_id = $class_id;
            $new_resource->resource_file = $resource_template->resource_file;
            $new_resource->filename = $resource_template->filename;
            $new_resource->save();
        }
    }

    public static function deleteClassResource($resources)
    {
        if (count($resources) > 0) {
            
            foreach ($resources as $resource) {
                // Storage::disk('s3')->delete($resource->resource_file);
                $resource->status = 0;
                $resource->update();
            }
        }
    }

    /**
     * Elimina los recursos que el usuario no desea al actualizar la clase
     */
    public static function destroyClassResource($paths, $class_id)
    {
        foreach ($paths as $index => $items) {
            $prefix = 'https://crm-storage-user.s3.eu-west-1.amazonaws.com/';
            $clean_path = str_replace($prefix, '', $paths[$index]);
            $database_path = ltrim($clean_path, '/');
            ClassResource::where('resource_file', $database_path)->delete();
            Storage::disk('s3')->delete($clean_path);
        }
    }

    public static function updateClassResource($resources, $user_id, $course_id, $class_id)
    {
        foreach ($resources as $index => $items) {

            $name = Helper::formatFilename($resources[$index]->getClientOriginalName());
            if(!ClassResource::where(['filename' => $name, 'class_id' => $class_id])->exists()){
                $path = 'courses/' . $user_id . '/' . $course_id  .   '/' . $class_id . '/' . 'resources/';
                $class_resource = new ClassResource();
                $class_resource->class_id = $class_id;
                $class_resource->resource_file = $path . $name;
                $class_resource->filename = $name;
                $class_resource->save();
                Storage::disk('s3')->put($path . $name, file_get_contents($resources[$index]), 'public');
            }
        }
    }

    public function delete($id){
        $resource = ClassResource::findOrFail($id);
        Storage::disk('s3')->delete($resource->resource_file);
        $resource->delete();
    }

    public function getResources($id){
        $resources = ClassResource::join('class', 'class_resources.class_id', '=', 'class.id')
            ->where('class.id', $id)
            ->select('class_resources.id', 'class_resources.filename as name', 'class_resources.resource_file as url')
            ->get();
        foreach ($resources as $resource) {
            $resource->url = env('AWS_S3_URL').'/'.$resource->url;
        }
        return $resources;
    }
}
