<?php

namespace App\Console\Commands;

use App\Mail\UserNotBuyerMailable;
use App\Models\ProductPayment;
use App\Models\User;
use Illuminate\Console\Command;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;

class SendEmailNotBuyers extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mail:SendEmailNotBuyers';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $users = User::leftJoin('product_payments', 'product_payments.user_id', 'users.id')
            ->select('users.created_at', 'users.name', 'users.email')
            ->where('product_payments.user_id', null)
            ->get();

        foreach ($users as $user) {

            if ($user->created_at == null) {
                $usercreated = Carbon::now();
            } else {
                $usercreated = Carbon::parse($user->created_at);
            }

            $now = Carbon::now();

            $diff = ($usercreated->diff($now)->days);

            if ($diff == 2) {
                $data = (object) array('username' => $user->name);
                $content = new UserNotBuyerMailable($data);

                Mail::to($user->email)
                    ->cc($user->email)
                    ->bcc($user->email)
                    ->send($content); 
            }

            if($diff == 30){
                $data = (object) array('username' => $user->name);
            $content = new UserNotBuyerMailable($data);

            Mail::to($user->email)
                ->cc($user->email)
                ->bcc($user->email)
                ->send($content);
            }   
        }
        echo ('Comando funcionando');
        echo (count($users));
        return 0;
    }
}
