const mix = require('laravel-mix');
const path = require('path');
/*
 |--------------------------------------------------------------------------
 | Mix Asset Management
 |--------------------------------------------------------------------------
 |
 | Mix provides a clean, fluent API for defining some Webpack build steps
 | for your Laravel application. By default, we are compiling the Sass
 | file for the application as well as bundling up all the JS files.
 |
 */

mix.js('resources/js/app.js', 'public/js')
    .vue()
    .sass('resources/sass/app.scss', 'public/css')
    .sass('resources/sass/style.scss', 'public/css')
    .sourceMaps();


if (mix.inProduction()) {
    mix.version();
}

mix.webpackConfig({
    resolve: {
        extensions: ['.js?id=1', '.vue?id=1'],
        alias: {
            '@': path.join(__dirname, './resources/js')
        }
    },
    optimization: {
        providedExports: false,
        sideEffects: false,
        usedExports: false
    }
})
mix.disableNotifications();