<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>PDF</title>
    <style>
    .table {
        width: 100%;
        border-collapse: collapse;
        border-spacing: 0;
        }

        .table th,
        .table td {
        padding: 10px;
        text-align: left;
        border-bottom: 1px solid #ddd;
        background-color: #f9f9f9;
        }

        .table th {
        background-color: #f2f2f2;
        }

        .table tbody tr:nth-child(even) {
        background-color: #f9f9f9;
        }

        .table th,
        .table td:first-child {
        border-left: none;
        }

        .table th:last-child,
        .table td:last-child {
        border-right: none;
        }
    </style>
</head>
<body>
  <h2>Razón Social: <?php echo e($matrix->corporation); ?></h2>
  <p>RUC: <?php echo e($matrix->ruc); ?></p>
  <table class="table">
    <thead>
      <tr>
        <th scope="col"></th>
        <th scope="col"></th>
        <th scope="col" colspan="8">IDENTIFICACIÓN</th>
        <th scope="col" colspan="9">EVALUACIÓN DEL RIESGO</th>
        <th scope="col" colspan="5">CONTROL OPERACIONAL</th>
        <th scope="col" colspan="8">EVALUACIÓN DEL RIESGO</th>
      </tr>
      <tr>
        <th scope="col">N°</th>
        <th scope="col">Proceso</th>
        <th scope="col">Tarea</th>
        <th scope="col">Posición de trabajo</th>
        <th scope="col">Lugar</th>
        <th scope="col">Rutinario</th>
        <th scope="col">Peligro</th>
        <th scope="col">Tipo</th>
        <th scope="col">Riesgo</th>
        <th scope="col">Consecuencias</th>
        <th scope="col">Índice de Personas Expuestas (A)</th>
        <th scope="col">Índice de Procedimientos Existentes (B)</th>
        <th scope="col">Índice de Capacitación (C)</th>
        <th scope="col">Índice de Exposición al Riesgo (D)</th>
        <th scope="col">Índice de Probabilidad de Ocurrencia (A+B+C+D)</th>
        <th scope="col">Índice de Severidad (IS)</th>
        <th scope="col">Probabilidad x Severidad (P x S)</th>
        <th scope="col">Nivel de Riesgo (NV)</th>
        <th scope="col">Riesgo Significativo (RS)</th>
        <th scope="col">Eliminación</th>
        <th scope="col">Sustitución</th>
        <th scope="col">Control de Ingeniería</th>
        <th scope="col">Control Administrativo</th>
        <th scope="col">EPPS</th>
        <th scope="col">Índice de Personas Expuestas (A)</th>
        <th scope="col">Índice de Procedimientos Existentes (B)</th>
        <th scope="col">Índice de Capacitación (C)</th>
        <th scope="col">Índice de Exposición al Riesgo (D)</th>
        <th scope="col">Índice de Probabilidad de Ocurrencia (A+B+C+D)</th>
        <th scope="col">Índice de Severidad (IS)</th>
        <th scope="col">Probabilidad x Severidad (P x S)</th>
        <th scope="col">Nivel de Riesgo (NV)</th>
      </tr>
    </thead>
    <tbody>
      <?php $__currentLoopData = $matrix->iperc; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iperx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <tr>
        <th scope="row"><?php echo e($loop->iteration); ?>}</th>
        <td><?php echo e($iperx->process ? $iperx->process->name : 'N/A'); ?></td>
        <td><?php echo e($iperx->task ? $iperx->task->description : 'N/A'); ?></td>
        <td><?php echo e($iperx->work_position ? $iperx->work_position->name : 'N/A'); ?></td>
        <td><?php echo e($iperx->place ? $iperx->place->name : 'N/A'); ?></td>
        <td><?php echo e($iperx->routine === 'Y' ? 'Rutinario' : 'No Rutinario'); ?></td>
        <td><?php echo e($iperx->danger ? $iperx->danger->description : 'N/A'); ?></td>
        <td><?php echo e($iperx->type ? $iperx->type : 'N/A'); ?></td>
        <td><?php echo e($iperx->risk ? $iperx->risk->description : 'N/A'); ?></td>
        <td><?php echo e($iperx->consequence ? $iperx->consequence->description : 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[0]->index_a ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[0]->index_b ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[0]->index_c ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[0]->index_d ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[0]->probability ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[0]->severity ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[0]->ps ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[0]->NV ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[0]->signification === 1 ? 'Sí' : 'No'); ?></td>
        <td><?php echo e($iperx->operationalControls[0]->elimination ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->operationalControls[0]->sustitution ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->operationalControls[0]->engineering_control ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->operationalControls[0]->admin_control ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->operationalControls[0]->epps ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[1]->index_a ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[1]->index_b ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[1]->index_c ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[1]->index_d ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[1]->probability ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[1]->severity ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[1]->ps ?? 'N/A'); ?></td>
        <td><?php echo e($iperx->risk->riskEvaluation[1]->NV ?? 'N/A'); ?></td>
      </tr>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>

  </table>
</body>
<?php /**PATH /home/promolider/public_html/crm_ipssoma/resources/views/matrix/pdf.blade.php ENDPATH**/ ?>