const username = document.getElementById('username');
const email = document.getElementById('email');
const password = document.getElementById('password');
const repassword = document.getElementById('repassword');
const user_type = document.getElementById('user_type');

const firstName = document.getElementById('name');
const lastName = document.getElementById('last_name');
const biography = document.getElementById('biography');
const phone = document.getElementById('phone');
const date_birth = document.getElementById('date_birth');
const nro_document = document.getElementById('nro_document');
const country = document.getElementById('country');
document.getElementById('btnFree').style.display = "none";

let stepper = new Stepper(document.querySelector('.bs-stepper'))
const accountTypes = document.getElementById('id_account_type');
const accountTypesPrice = document.getElementById('account_type-price');
const accountTypesIva = document.getElementById('account_type-iva');
const accountTypesTotalCostMembreship = document.getElementById('account_type-total_cost_membreship');
const documentTypes = document.getElementById('id_document_type');
const payment_method = document.getElementById('payment_method_id');
const purchase_number = document.getElementById('purchase_number');
var optionRegisterSelected = 0; // 0 -> registro pagado, 1 -> registro gratis
function accountTypesChanged(list_account_type) {
    const option_actual = accountTypes.value
    list_account_type.forEach(element => {
        if (element.id == option_actual) {
            if(element.account == 'Guest'){
                optionRegisterSelected = 1;
                document.getElementById('btnPay').style.display = "none";
                document.getElementById('btnFree').style.display = "block"
                document.getElementById('payment_method_selector').style.visibility = "hidden";
            }else{
                document.getElementById('btnFree').style.display = "none";
                document.getElementById('btnPay').style.display = "block";
                document.getElementById('payment_method_selector').style.visibility = "visible";
            }
            accountTypesPrice.value = '$ ' + Number.parseFloat(element.price).toFixed(2);
            accountTypesIva.value = element.iva + '%';
            let amount = Number.parseFloat(element.total).toFixed(2);
            accountTypesTotalCostMembreship.value = '$ ' + amount;
        }
    });
};

//show account type after select user type
function userTypesChanged(list_account_type) {
    limpiarSelect();
    const option_actual = user_type.value
    indice_basic = list_account_type.findIndex(array => array.account == 'Basic')
    indice_guest = list_account_type.findIndex(array => array.account == 'Guest')
    if (option_actual == 'Producer') {
        list_account_type.splice(indice_guest)
    }
    else if (option_actual == 'Distributor') {
        list_account_type.splice(indice_basic, 1)
    }
    list_account_type.forEach(element => {
        var option = document.createElement("option");
        option.innerHTML = element.account
        option.value = element.id
        accountTypes.appendChild(option)
    });

    accountTypesChanged(list_account_type)
};

function limpiarSelect() {
    for (let i = accountTypes.options.length; i >= 0; i--) {
        accountTypes.options[i] = null;
    }
}

/////////////////////////// Function Validation

function validDocumentType(list_document_type) {
    nro_document.value = ""
    const option_actual = documentTypes.options[documentTypes.selectedIndex].text;
    nro_document.setAttribute('class', 'form-control is-invalid')
    list_document_type.forEach(element => {
        if (option_actual == "DNI") {
            nro_document.setAttribute("maxlength", "8")
            nro_document.setAttribute("minlength", "8")
        } else {
            nro_document.setAttribute("maxlength", "12")
            nro_document.setAttribute("minlength", "12")
        }
    })
}
function validDocumentTypeStyles(id) {
    let element = document.getElementById(id);
    const option_actual = documentTypes.options[documentTypes.selectedIndex].text;
    tamaño = element.value;
    if (option_actual == "DNI" && tamaño.length < 8) {
        element.setAttribute('class', 'form-control is-invalid');
    } else {
        if (option_actual != "DNI" && tamaño.length < 12) {
            element.setAttribute('class', 'form-control is-invalid');
        } else {
            element.setAttribute('class', 'form-control');
        }
    }
}

function numberOnly(id) {
    let element = document.getElementById(id);
    element.value = element.value.replace(/[^0-9]/gi, "");

    if (id == "nro_document") {
        validDocumentTypeStyles('nro_document')
    }
}

function lettersOnly(e) {
    tecla = (document.all) ? e.keyCode : e.which;

    if (tecla == 8 || tecla == 32) {
        return true;
    }

    patron = /[A-Za-z]/;
    tecla_final = String.fromCharCode(tecla);
    return patron.test(tecla_final);
}

function checkCharactersSpecial(e) {
    tecla = (document.all) ? e.keyCode : e.which;

    if (tecla == 8) {
        return true;
    }

    patron = /[A-Za-z0-9]/;
    tecla_final = String.fromCharCode(tecla);
    return patron.test(tecla_final);
}

function validDateBirth() {
    const date_now = new Date();
    let year_now = date_now.getFullYear();
    let minLegalAge = year_now - 18;
    date_birth.setAttribute('max', "" + minLegalAge + "-01-01")
}

function mostrarContra(id_input) {
    const eyes_close = 'M2,5.27L3.28,4L20,20.72L18.73,22L15.65,18.92C14.5,19.3 13.28,19.5 12,19.5C7,19.5 2.73,16.39 1,12C1.69,10.24 2.79,8.69 4.19,7.46L2,5.27M12,9A3,3 0 0,1 15,12C15,12.35 14.94,12.69 14.83,13L11,9.17C11.31,9.06 11.65,9 12,9M12,4.5C17,4.5 21.27,7.61 23,12C22.18,14.08 20.79,15.88 19,17.19L17.58,15.76C18.94,14.82 20.06,13.54 20.82,12C19.17,8.64 15.76,6.5 12,6.5C10.91,6.5 9.84,6.68 8.84,7L7.3,5.47C8.74,4.85 10.33,4.5 12,4.5M3.18,12C4.83,15.36 8.24,17.5 12,17.5C12.69,17.5 13.37,17.43 14,17.29L11.72,15C10.29,14.85 9.15,13.71 9,12.28L5.6,8.87C4.61,9.72 3.78,10.78 3.18,12Z'
    const eyes_open = 'M12,9A3,3 0 0,1 15,12A3,3 0 0,1 12,15A3,3 0 0,1 9,12A3,3 0 0,1 12,9M12,4.5C17,4.5 21.27,7.61 23,12C21.27,16.39 17,19.5 12,19.5C7,19.5 2.73,16.39 1,12C2.73,7.61 7,4.5 12,4.5M3.18,12C4.83,15.36 8.24,17.5 12,17.5C15.76,17.5 19.17,15.36 20.82,12C19.17,8.64 15.76,6.5 12,6.5C8.24,6.5 4.83,8.64 3.18,12Z'
    let lblPassword = document.getElementById(id_input);
    let icon = document.getElementById(id_input + "-icon");

    if (lblPassword.type == 'password') {
        lblPassword.type = 'text';
        icon.setAttribute('d', eyes_close)
    } else {
        lblPassword.type = 'password';
        icon.setAttribute('d', eyes_open)
    }
}
//////////////////////////////////////////
function printError(listaErrores) {
    clearError();
    if (listaErrores.username) {
        username.setAttribute('class', 'form-control is-invalid');
        document.getElementById('username_error').innerHTML = listaErrores.username;
    }
    if (listaErrores.email) {
        email.setAttribute('class', 'form-control is-invalid');
        document.getElementById('email_error').innerHTML = listaErrores.email;
    }
    if (listaErrores.password) {
        password.setAttribute('class', 'form-control is-invalid');
        document.getElementById('password_error').innerHTML = listaErrores.password;
    }
    if (listaErrores.user_type) {
        user_type.setAttribute('class', 'form-control is-invalid');
        document.getElementById('user_type_error').innerHTML = listaErrores.user_type;
    }
    if (listaErrores.id_account_type) {
        accountTypes.setAttribute('class', 'form-control is-invalid');
        document.getElementById('id_account_type_error').innerHTML = listaErrores.id_account_type;
    }
    if (listaErrores.id_document_type) {
        documentTypes.setAttribute('class', 'form-control is-invalid');
        document.getElementById('id_document_type_error').innerHTML = listaErrores.id_document_type;
    }
    if (listaErrores.name) {
        firstName.setAttribute('class', 'form-control is-invalid');
        document.getElementById('name_error').innerHTML = listaErrores.name;
    }
    if (listaErrores.last_name) {
        lastName.setAttribute('class', 'form-control is-invalid');
        document.getElementById('last_name_error').innerHTML = listaErrores.last_name;
    }
    if (listaErrores.biography) {
        biography.setAttribute('class', 'form-control is-invalid');
        document.getElementById('biography_error').innerHTML = listaErrores.biography;
    }
    if (listaErrores.phone) {
        phone.setAttribute('class', 'form-control is-invalid');
        document.getElementById('phone_error').innerHTML = listaErrores.phone;
    }
    if (listaErrores.date_birth) {
        date_birth.setAttribute('class', 'form-control is-invalid');
        document.getElementById('date_birth_error').innerHTML = listaErrores.date_birth;
    }
    if (listaErrores.nro_document) {
        nro_document.setAttribute('class', 'form-control is-invalid');
        document.getElementById('nro_document_error').innerHTML = listaErrores.nro_document;
    }

    if (listaErrores.payment_method) {
        payment_method.setAttribute('class', 'form-control is-invalid');
        document.getElementById('payment_method_id_error').innerHTML = listaErrores.payment_method;
    }
}

function clearError() {
    username.setAttribute('class', 'form-control');
    document.getElementById('username_error').innerHTML = "";
    email.setAttribute('class', 'form-control');
    document.getElementById('email_error').innerHTML = "";
    password.setAttribute('class', 'form-control');
    document.getElementById('password_error').innerHTML = "";
    user_type.setAttribute('class', 'form-control');
    document.getElementById('user_type_error').innerHTML = "";
    accountTypes.setAttribute('class', 'form-control');
    document.getElementById('id_account_type_error').innerHTML = "";
    documentTypes.setAttribute('class', 'form-control');
    document.getElementById('id_document_type_error').innerHTML = "";
    firstName.setAttribute('class', 'form-control');
    document.getElementById('name_error').innerHTML = "";
    lastName.setAttribute('class', 'form-control');
    document.getElementById('last_name_error').innerHTML = "";
    biography.setAttribute('class', 'form-control');
    document.getElementById('biography_error').innerHTML = "";
    phone.setAttribute('class', 'form-control');
    document.getElementById('phone_error').innerHTML = "";
    date_birth.setAttribute('class', 'form-control');
    document.getElementById('date_birth_error').innerHTML = "";
    nro_document.setAttribute('class', 'form-control');
    document.getElementById('nro_document_error').innerHTML = "";
}

function viewError(listaErrores) {
    if (listaErrores.username) {
        stepper.to(1)
    }
    else if (listaErrores.email) {
        stepper.to(1)
    }
    else if (listaErrores.password) {
        stepper.to(1)
    }
    else if (listaErrores.user_type) {
        stepper.to(1)
    }
    else if (listaErrores.id_document_type) {
        stepper.to(2)
    }
    else if (listaErrores.name) {
        stepper.to(2)
    }
    else if (listaErrores.last_name) {
        stepper.to(2)
    }
    else if (listaErrores.biography) {
        stepper.to(2)
    }
    else if (listaErrores.phone) {
        stepper.to(2)
    }
    else if (listaErrores.date_birth) {
        stepper.to(2)
    }
    else if (listaErrores.nro_document) {
        stepper.to(2)
    }
    else if (listaErrores.id_account_type) {
        stepper.to(3)
    }
}

function useRegex(input) {
    let regex = /(?=.*\d)(?=.*[a-z])(?=.*[A-Z])((?=.*\W)|(?=.*_))^[^ ]+$/g;
    return regex.test(input);
}

function validPassword(new_pas, conf_pas) {
    if (new_pas == '' || new_pas.length <= 0) {
      alert('Ingrese una contraseña');
      return false;
    }

    if (new_pas != conf_pas) {
      alert('Las contraseñas no coinciden');
      return false;
    }
    if (new_pas.length < 8) {
      alert('La contraseña debe tener como mínimo 8 caracteres');
      return false;
    }
    if (!this.useRegex(new_pas)) {
      alert('La contraseña debe tener como mínimo 1 letra minúscula,una letra mayúscula, 1 digito y 1 caracter especial');
      return false;
    }
    return true;
  }

function register(url, sponsor) {
if(validPassword(password.value,repassword.value)){


    var payment = "";

    if(optionRegisterSelected == 1){
        payment = 'free';
    }else{
        if(payment_method.value == 0){
            return alert("Debe seleccionar un metodo de pago");
        } 
    
        if(payment_method.value == 1){
            payment = 'niubiz';
        }
    
        if(payment_method.value == 2){
            return alert('metodo de pago aun no implementado');
        }
        if(payment_method.value == 3){
            return alert('metodo de pago aun no implementado');
        }
    
        if(payment_method.value == 4){
            payment = 'paypal';
        }
    }


    const formData = new FormData();
    // validar metodo de pago vacio y demas
    formData.append('id_referrer_sponsor', sponsor);
    formData.append('username', username.value);
    formData.append('email', email.value);
    formData.append('password', password.value);
    formData.append('password_confirmation', repassword.value);
    formData.append('user_type', user_type.value);

    formData.append('name', firstName.value);
    formData.append('last_name', lastName.value);
    formData.append('biography', biography.value);
    formData.append('phone', phone.value);
    formData.append('date_birth', date_birth.value);
    formData.append('id_document_type', documentTypes.value);
    formData.append('nro_document', nro_document.value);
    formData.append('id_country', country.value);
    formData.append('id_account_type', accountTypes.value);
    formData.append('purchase_number', purchase_number.value);
    formData.append('payment_method', payment);

    if(optionRegisterSelected == 1){
        axios.post('/users/create-free', formData).then((response) => {
            window.location.href = "{{ route('redirect-with-message')}}";
        });
    }else{
        fetch(url, {
            method: 'POST',
            body: JSON.stringify(Object.fromEntries(formData)),
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
            },
        }).then(response => response.json())
            .catch(error => console.log(error))
            .then(response => {
                if (response.errors) {
                    printError(response.errors);
                    viewError(response.errors);
                } else {
                    window.location.href = response
                }
            });
    }
    }
}

function next() {
    stepper.next()
}
function previus() {
    stepper.previous()
}