<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TaskSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $tasks = [
            'Revisión de documentos',
            'Mantenimiento de equipos',
            'Atención al cliente',
            'Gestión de inventario',
            // Agrega más tareas según sea necesario
        ];

        // Iterar sobre cada tarea y crear un registro en la tabla 'tasks'
        foreach ($tasks as $task) {
            DB::table('tasks')->insert([
                'description' => $task,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
