<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class RiskSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $risks = [
            'Riesgo químico',
            'Riesgo ergonómico',
            'Riesgo biológico',
            'Riesgo psicosocial',
            // Agrega más riesgos según sea necesario
        ];

        // Iterar sobre cada riesgo y crear un registro en la tabla 'risks'
        foreach ($risks as $risk) {
            DB::table('risks')->insert([
                'description' => $risk,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
