<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClassTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('class', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('id_modules');
            $table->text('name');
            $table->time('time')->nullable();
            $table->string('url');
            $table->longtext('description')->nullable();
            $table->tinyInteger('public_status');
            $table->boolean('is_preview')->default(0);
            $table->timestamps();

            $table->foreign('id_modules')->references('id')->on('modules')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('class');
    }
}
