<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class FixDatabaseStructureFinal extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // crear tabla Reviews (si no existe)
        if (!Schema::hasTable('reviews')) {
            Schema::create('reviews', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('product_id')->nullable();
                $table->unsignedBigInteger('user_id')->nullable();
                $table->integer('rating')->default(5);
                $table->text('comment')->nullable();
                $table->timestamps();
            });
        }

        // crear tabla Instructors (si no existe)
        if (!Schema::hasTable('instructors')) {
            Schema::create('instructors', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->string('last_name')->nullable();
                $table->string('email')->nullable();
                $table->text('description')->nullable();
                $table->string('imagen')->nullable();
                $table->timestamps();
            });
        }

    
        if (!Schema::hasTable('banners')) {
            Schema::create('banners', function (Blueprint $table) {
                $table->id();
                $table->string('title')->nullable();
                $table->string('imagen')->nullable();
                $table->integer('state')->default(1);
                $table->timestamps();
            });
        }

        
        Schema::table('product_payments', function (Blueprint $table) {
            if (!Schema::hasColumn('product_payments', 'status')) {
                $table->integer('status')->default(1); 
            }
            if (!Schema::hasColumn('product_payments', 'product_type')) {
                $table->integer('product_type')->nullable()->default(1);
            }
        });
        
        // 5. Asegurar columnas faltantes en Class (public_status, slug y status)
        if (Schema::hasTable('class')) {
             Schema::table('class', function (Blueprint $table) {
                // 5.1 public_status
                if (!Schema::hasColumn('class', 'public_status')) {
                    $table->tinyInteger('public_status')->default(0);
                }
                
                // 5.2 slug (Para URL de examenes)
                if (!Schema::hasColumn('class', 'slug')) {
                    $table->string('slug')->nullable()->after('name');
                }

                // 5.3 status (Para saber si la clase está activa)
                if (!Schema::hasColumn('class', 'status')) {
                    $table->tinyInteger('status')->default(1);
                }
            });
        }

        // 6. Asegurar columnas faltantes en Exams
        if (Schema::hasTable('exams')) {
             Schema::table('exams', function (Blueprint $table) {
                // 6.1 module_id
                if (!Schema::hasColumn('exams', 'module_id')) {
                    $table->unsignedBigInteger('module_id')->nullable();
                }

                // 6.2 course_id (NUEVO)
                if (!Schema::hasColumn('exams', 'course_id')) {
                    $table->unsignedBigInteger('course_id')->nullable();
                }

                // 6.3 status
                if (!Schema::hasColumn('exams', 'status')) {
                    $table->tinyInteger('status')->default(1);
                }
            });
        }

        // 7. Hacer permisiva la tabla product_payments (Tu fix de Diego)
        if (Schema::hasTable('product_payments')) {
            Schema::table('product_payments', function (Blueprint $table) {
                // Intentamos eliminar la llave foránea para evitar errores de integridad
                // Usamos un array con el nombre de la columna, Laravel deduce el nombre del índice
                try {
                    $table->dropForeign(['product_id']);
                } catch (\Exception $e) {
                    // Si no existe o falla, no hacemos nada y seguimos
                }
            });
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        
    }
}