<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateChatbotIpercTables extends Migration
{
    /**
     * Run the migrations.
     * Crea todas las tablas necesarias para el módulo Chatbot e IPERC.
     *
     * @return void
     */
    public function up()
    {
        // 1. Tablas Catálogos (Simples)
        if (!Schema::hasTable('places')) {
            Schema::create('places', function (Blueprint $table) {
                $table->id();
                $table->string('name', 160);
                $table->timestamps();
            });
        }

        if (!Schema::hasTable('work_positions')) {
            Schema::create('work_positions', function (Blueprint $table) {
                $table->id();
                $table->string('name', 160);
                $table->timestamps();
            });
        }

        if (!Schema::hasTable('processes')) {
            Schema::create('processes', function (Blueprint $table) {
                $table->id();
                $table->string('name')->nullable();
                $table->timestamps();
            });
        }

        // 2. Tablas de Descripción (Textos)
        $textTables = ['tasks', 'dangers', 'risks', 'consequences'];
        foreach ($textTables as $tableName) {
            if (!Schema::hasTable($tableName)) {
                Schema::create($tableName, function (Blueprint $table) {
                    $table->id();
                    $table->text('description')->nullable();
                    $table->timestamps();
                });
            }
        }

        // 3. Tabla Matrix (Cabecera)
        if (!Schema::hasTable('matrix')) {
            Schema::create('matrix', function (Blueprint $table) {
                $table->id();
                $table->string('corporation', 400)->nullable();
                $table->string('ruc', 11)->nullable();
                $table->timestamps();
            });
        }

        // 4. Tabla IPERC (Central) - En SINGULAR
        if (!Schema::hasTable('iperc')) {
            Schema::create('iperc', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('matrix_id');
                $table->unsignedBigInteger('places_id');
                $table->unsignedBigInteger('processes_id');
                $table->unsignedBigInteger('tasks_id');
                $table->unsignedBigInteger('work_positions_id');
                $table->unsignedBigInteger('risks_id');
                $table->unsignedBigInteger('dangers_id');
                $table->unsignedBigInteger('consequences_id');
                $table->string('type')->nullable(); 
                $table->string('routine', 5)->nullable();
                $table->timestamps();
            });
        }

        // 5. Tabla de Evaluación de Riesgo - En SINGULAR + Columnas Calculadas
        if (!Schema::hasTable('risk_evaluation')) {
            Schema::create('risk_evaluation', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('risks_id')->nullable();
                $table->integer('index_a')->nullable();
                $table->integer('index_b')->nullable();
                $table->integer('index_c')->nullable();
                $table->integer('index_d')->nullable();
                $table->integer('severity')->nullable();
                $table->boolean('signification')->default(0);
                $table->string('type')->nullable(); // 'base' o 'residual'
                
                // Columnas calculadas (Las que agregamos al final)
                $table->integer('probability')->nullable();
                $table->integer('ps')->nullable(); // Probabilidad x Severidad
                $table->string('NV', 10)->nullable(); // Nivel de Valoración

                $table->timestamps();
            });
        }

        // 6. Tabla de Control Operacional - En SINGULAR
        if (!Schema::hasTable('operational_control')) {
            Schema::create('operational_control', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('iperc_id');
                $table->text('elimination')->nullable();
                $table->text('sustitution')->nullable();
                $table->text('engineering_control')->nullable();
                $table->text('admin_control')->nullable();
                $table->text('epps')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     * Elimina las tablas si se revierte la migración.
     *
     * @return void
     */
    public function down()
    {
        // Borrar en orden inverso para evitar problemas de claves foráneas (si las hubiera)
        Schema::dropIfExists('operational_control');
        Schema::dropIfExists('risk_evaluation');
        Schema::dropIfExists('iperc');
        Schema::dropIfExists('matrix');
        Schema::dropIfExists('consequences');
        Schema::dropIfExists('risks');
        Schema::dropIfExists('dangers');
        Schema::dropIfExists('tasks');
        Schema::dropIfExists('processes');
        Schema::dropIfExists('work_positions');
        Schema::dropIfExists('places');
    }
}